(ns
 pandect.algo.ripemd160
 "RipeMD160 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1259 (compute-ripemd1601257 [data1258]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1259 #'compute-ripemd1601257]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1259
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd1601257
    [data1258]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "RipeMD160")]
     (.digest md__682__auto__ data1258)))
   java.lang.String
   (compute-ripemd1601257
    [data1258]
    (clojure.core/let
     [data1258 (.getBytes data1258 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "RipeMD160")]
      (.digest md__682__auto__ data1258)))))
  (clojure.core/extend-protocol
   G__1259
   java.io.InputStream
   (compute-ripemd1601257
    [data1258]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "RipeMD160")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1258]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-ripemd1601257
    [data1258]
    (clojure.core/with-open
     [data1258 (clojure.java.io/input-stream data1258)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "RipeMD160")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1258]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1259)
 (do
  (clojure.core/defn
   ripemd160*
   "[Hash] RipeMD160 (raw value)"
   [x]
   (compute-ripemd1601257 x))
  (clojure.core/defn
   ripemd160-file*
   "[Hash] RipeMD160 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd1601257 x)))
  (clojure.core/defn
   ripemd160-bytes
   "[Hash] RipeMD160 (value -> byte array)"
   [x]
   (compute-ripemd1601257 x))
  (clojure.core/defn
   ripemd160-file-bytes
   "[Hash] RipeMD160 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd1601257 x)))
  (clojure.core/defn
   ripemd160
   "[Hash] RipeMD160 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-ripemd1601257 x)))
  (clojure.core/defn
   ripemd160-file
   "[Hash] RipeMD160 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-ripemd1601257 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1272
   (compute-ripemd1601269 [data1270 key1271]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1272 #'compute-ripemd1601269]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1272
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd1601269
    [data1270 key1271]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD160")
      msg__558__auto__
      (clojure.core/bytes data1270)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1271 "Hmac-RipeMD160")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-ripemd1601269
    [data1270 key1271]
    (clojure.core/let
     [data1270 (.getBytes data1270 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD160")
       msg__558__auto__
       (clojure.core/bytes data1270)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1271 "Hmac-RipeMD160")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1272
   java.io.InputStream
   (compute-ripemd1601269
    [data1270 key1271]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD160")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1271 "Hmac-RipeMD160")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1270]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-ripemd1601269
    [data1270 key1271]
    (clojure.core/with-open
     [data1270 (clojure.java.io/input-stream data1270)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD160")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1271 "Hmac-RipeMD160")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1270]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1272)
 (do
  (clojure.core/defn
   ripemd160-hmac*
   "[HMAC] Hmac-RipeMD160 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd1601269
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd160-hmac-file*
   "[HMAC] Hmac-RipeMD160 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd1601269
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd160-hmac-bytes
   "[HMAC] Hmac-RipeMD160 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd1601269
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd160-hmac-file-bytes
   "[HMAC] Hmac-RipeMD160 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd1601269
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd160-hmac
   "[HMAC] Hmac-RipeMD160 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-ripemd1601269
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd160-hmac-file
   "[HMAC] Hmac-RipeMD160 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-ripemd1601269
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
