(ns
 pandect.algo.keccak-224
 "Keccak-224 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol
   G__1206
   (compute-keccak-2241204 [data1205]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1206 #'compute-keccak-2241204]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1206
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-2241204
    [data1205]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "Keccak-224")]
     (.digest md__682__auto__ data1205)))
   java.lang.String
   (compute-keccak-2241204
    [data1205]
    (clojure.core/let
     [data1205 (.getBytes data1205 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "Keccak-224")]
      (.digest md__682__auto__ data1205)))))
  (clojure.core/extend-protocol
   G__1206
   java.io.InputStream
   (compute-keccak-2241204
    [data1205]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "Keccak-224")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1205]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-keccak-2241204
    [data1205]
    (clojure.core/with-open
     [data1205 (clojure.java.io/input-stream data1205)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "Keccak-224")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1205]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1206)
 (do
  (clojure.core/defn
   keccak-224*
   "[Hash] Keccak-224 (raw value)"
   [x]
   (compute-keccak-2241204 x))
  (clojure.core/defn
   keccak-224-file*
   "[Hash] Keccak-224 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2241204 x)))
  (clojure.core/defn
   keccak-224-bytes
   "[Hash] Keccak-224 (value -> byte array)"
   [x]
   (compute-keccak-2241204 x))
  (clojure.core/defn
   keccak-224-file-bytes
   "[Hash] Keccak-224 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2241204 x)))
  (clojure.core/defn
   keccak-224
   "[Hash] Keccak-224 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-keccak-2241204 x)))
  (clojure.core/defn
   keccak-224-file
   "[Hash] Keccak-224 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-keccak-2241204 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1242
   (compute-keccak-2241239 [data1240 key1241]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1242 #'compute-keccak-2241239]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1242
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-2241239
    [data1240 key1241]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak224")
      msg__558__auto__
      (clojure.core/bytes data1240)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1241 "Hmac-Keccak224")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-keccak-2241239
    [data1240 key1241]
    (clojure.core/let
     [data1240 (.getBytes data1240 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak224")
       msg__558__auto__
       (clojure.core/bytes data1240)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1241 "Hmac-Keccak224")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1242
   java.io.InputStream
   (compute-keccak-2241239
    [data1240 key1241]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak224")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1241 "Hmac-Keccak224")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1240]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-keccak-2241239
    [data1240 key1241]
    (clojure.core/with-open
     [data1240 (clojure.java.io/input-stream data1240)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak224")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1241 "Hmac-Keccak224")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1240]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1242)
 (do
  (clojure.core/defn
   keccak-224-hmac*
   "[HMAC] Hmac-Keccak224 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-2241239
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-224-hmac-file*
   "[HMAC] Hmac-Keccak224 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2241239
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-224-hmac-bytes
   "[HMAC] Hmac-Keccak224 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-2241239
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-224-hmac-file-bytes
   "[HMAC] Hmac-Keccak224 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2241239
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-224-hmac
   "[HMAC] Hmac-Keccak224 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-keccak-2241239
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-224-hmac-file
   "[HMAC] Hmac-Keccak224 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-keccak-2241239
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
