(ns com.edocu.help.handlers.protocols
  (:require [clojure.tools.logging :as log]
            [io.pedestal.interceptor.helpers :as interceptors]
            [io.pedestal.interceptor.chain :as chain]
            [clojure.core.async :as async :refer [put! close!]]
            [ring.util.response :as ring-response]
            [environ.core :as e]
            [buddy.auth.middleware :as buddy]
            [buddy.auth.backends :as backends]))

(defn secret []
  (or (e/env :secret) "APfcwZVfuOuquZKIolzb7wGsDyUhm7lo"))

(defprotocol Routes
  (routes [this] "Return routes"))

(defn user-uid
  "Return UID of user from request"
  [request]
  (or
    (ring-response/get-header request "x-credential-username")
    (ring-response/get-header request "uid")
    "open"))

(defn- request-identity-fn
  [{:keys [request response-channel] :as context}]
  (try
    (log/trace "request-identity. Authorization:" (ring-response/get-header request "authorization"))
    (let [user (buddy/authenticate-request request [(backends/jws {:secret (secret)})])]
      (log/trace "request-identity. User:" user)
      (assoc context
        :user
        user))
    (catch Exception e
      (log/error e "request-identity")
      (let [response (-> (ring-response/response "")
                         (ring-response/status 400))]
        (put! response-channel response (fn [_] (close! response-channel)))
        (-> context
            (assoc :response response)
            (chain/terminate))))))

(defn request-identity
  "Return Pedestal Interceptor which slurp identity from request"
  []
  (interceptors/before
    ::request-identity #'request-identity-fn))
