(ns com.edocu.help.server.system
  (:require [com.stuartsierra.component :as component]
            [com.edocu.help.server.nginx :as server]
            [clojure.tools.logging :as log]))

(def pedestal-handler (promise))

(defn handler
  "Main handler for all requests from nginx"
  [request]
  (let [handler @pedestal-handler]
    (handler request)))

(defn init
  "Init system"
  [system args]
  (let [{:keys [pedestal]} (component/start (system args))
        handler (get-in pedestal [:service ::server/handler])]
    (deliver pedestal-handler handler))
  (log/info "System is running")
  {:status 200})
