(ns com.edocu.help.db.neo4j
  (:require [com.stuartsierra.component :as component]
            [clojure.tools.logging :as log]
            [environ.core :as e]
            [clojurewerkz.neocons.rest :as nr]
            [com.edocu.help.sentry :as sentry]))

(defprotocol Client
  (client [this] "Return neocons client"))

(defrecord NeoconsClient [client]
  component/Lifecycle
  (start [this]
    (log/trace "Starting NeoconsClient")
    (assoc this
      :client (delay
                (try
                  (let [username (e/env :neo4j-username)
                        password (e/env :neo4j-password)
                        url (str (e/env :neo4j-url) "/db/data/")
                        connection-args (if (and username password)
                                          [url username password]
                                          [url])]
                    (apply nr/connect connection-args))
                  (catch Exception e
                    (sentry/put-in-mdc {:url (e/env :neo4j-url)})
                    (log/error e "NeoconsClient")
                    nil)))))
  (stop [this]
    (log/trace "Stopping NeoconsClient")
    (dissoc this :client))

  Client
  (client [this]
    @client))

(defn ->neocons-client
  "Return component for neocons client"
  []
  (map->NeoconsClient {}))