/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit;

import clojure.lang.ISeq;
import clojure.lang.Seqable;
import java.util.Arrays;
import java.util.Map;
import org.httpkit.DynamicBytes;
import org.httpkit.HttpUtils;

public class HeaderMap {
    public final int INIT_SIZE = 8;
    private int size = 0;
    private Object[] arrays = new Object[16];

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void put(String key, Object obj) {
        int total = this.size * 2;
        if (total == this.arrays.length) {
            this.arrays = Arrays.copyOf(this.arrays, this.arrays.length * 2);
        }
        this.arrays[total] = key;
        this.arrays[total + 1] = obj;
        ++this.size;
    }

    public void putOrReplace(String key, Object obj) {
        int total = this.size * 2;
        for (int i = 0; i < total; i += 2) {
            if (!key.equals(this.arrays[i])) continue;
            this.arrays[i + 1] = obj;
            return;
        }
        this.put(key, obj);
    }

    public Object get(String key) {
        int total = this.size << 1;
        for (int i = 0; i < total; i += 2) {
            if (!key.equals(this.arrays[i])) continue;
            return this.arrays[i + 1];
        }
        return null;
    }

    public boolean containsKey(String key) {
        int total = this.size * 2;
        for (int i = 0; i < total; i += 2) {
            if (!key.equals(this.arrays[i])) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.size = 0;
    }

    public static HeaderMap camelCase(Map<String, Object> map) {
        HeaderMap tmp = new HeaderMap();
        if (map != null) {
            for (Map.Entry<String, Object> e : map.entrySet()) {
                tmp.put(HttpUtils.camelCase(e.getKey()), e.getValue());
            }
        }
        return tmp;
    }

    public void encodeHeaders(DynamicBytes bytes) {
        int total = this.size * 2;
        for (int i = 0; i < total; i += 2) {
            String k = (String)this.arrays[i];
            Object v = this.arrays[i + 1];
            if (v instanceof Seqable) {
                for (ISeq seq = ((Seqable)v).seq(); seq != null; seq = seq.next()) {
                    bytes.append(k);
                    bytes.append((byte)58, (byte)32);
                    bytes.append(seq.first().toString(), HttpUtils.UTF_8);
                    bytes.append((byte)13, (byte)10);
                }
                continue;
            }
            bytes.append(k);
            bytes.append((byte)58, (byte)32);
            bytes.append(v.toString(), HttpUtils.UTF_8);
            bytes.append((byte)13, (byte)10);
        }
        bytes.append((byte)13, (byte)10);
    }
}

