/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.timer;

import clojure.lang.IFn;
import java.util.concurrent.atomic.AtomicBoolean;
import org.httpkit.PriorityQueue;

public class CancelableFutureTask
implements Comparable<CancelableFutureTask> {
    private final int timeout;
    private final IFn futureTask;
    public final long timeoutTs;
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final PriorityQueue<CancelableFutureTask> queue;

    public CancelableFutureTask(int timeout, IFn task, PriorityQueue<CancelableFutureTask> queue2) {
        this.timeoutTs = System.currentTimeMillis() + (long)timeout;
        this.timeout = timeout;
        this.futureTask = task;
        this.queue = queue2;
    }

    public String toString() {
        long now = System.currentTimeMillis();
        if (this.done.get()) {
            return "timeout=" + this.timeout + "ms, done or canceled";
        }
        return "timeout=" + this.timeout + "ms, due in " + (this.timeoutTs - now) + "ms";
    }

    public void runTask() {
        if (this.done.compareAndSet(false, true)) {
            this.futureTask.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        boolean b = this.done.compareAndSet(false, true);
        if (b) {
            PriorityQueue<CancelableFutureTask> priorityQueue = this.queue;
            synchronized (priorityQueue) {
                this.queue.remove(this);
            }
        }
        return b;
    }

    @Override
    public int compareTo(CancelableFutureTask o) {
        return (int)(this.timeoutTs - o.timeoutTs);
    }
}

