/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import javax.net.ssl.SSLException;
import org.httpkit.PriorityQueue;
import org.httpkit.client.Decoder;
import org.httpkit.client.IRespListener;
import org.httpkit.client.RequestConfig;

public class Request
implements Comparable<Request> {
    final InetSocketAddress addr;
    final Decoder decoder;
    final ByteBuffer[] request;
    final RequestConfig cfg;
    private final PriorityQueue<Request> clients;
    private boolean isDone = false;
    boolean isReuseConn = false;
    boolean isConnected = false;
    SelectionKey key;
    private long timeoutTs;

    public Request(InetSocketAddress addr, ByteBuffer[] request2, IRespListener handler, PriorityQueue<Request> clients, RequestConfig config) {
        this.cfg = config;
        this.decoder = new Decoder(handler, config.method);
        this.request = request2;
        this.clients = clients;
        this.addr = addr;
        this.timeoutTs = (long)config.timeout + System.currentTimeMillis();
    }

    public void onProgress(long now) {
        if ((long)this.cfg.timeout + now - this.timeoutTs > 800L) {
            this.clients.remove(this);
            this.timeoutTs = (long)this.cfg.timeout + now;
            this.clients.offer(this);
        }
    }

    public void finish() {
        this.clients.remove(this);
        if (this.isDone) {
            return;
        }
        this.isDone = true;
        this.decoder.listener.onCompleted();
    }

    public boolean isTimeout(long now) {
        return this.timeoutTs < now;
    }

    public void finish(Throwable t) {
        this.clients.remove(this);
        if (this.isDone) {
            return;
        }
        this.isDone = true;
        this.decoder.listener.onThrowable(t);
    }

    @Override
    public int compareTo(Request o) {
        return (int)(this.timeoutTs - o.timeoutTs);
    }

    public void recycle(Request old) throws SSLException {
        this.key = old.key;
    }
}

