/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.httpkit.LineTooLargeException;

public class LineReader {
    byte[] lineBuffer = new byte[1024];
    int lineBufferIdx = 0;
    private final int maxLine;

    public LineReader(int maxLine) {
        this.maxLine = maxLine;
    }

    public String readLine(ByteBuffer buffer) throws LineTooLargeException {
        boolean more = true;
        while (buffer.hasRemaining() && more) {
            byte b = buffer.get();
            if (b == 13) {
                if (!buffer.hasRemaining() || buffer.get() != 10) continue;
                more = false;
                continue;
            }
            if (b == 10) {
                more = false;
                continue;
            }
            if (this.lineBufferIdx == this.maxLine - 2) {
                throw new LineTooLargeException("exceed max line " + this.maxLine);
            }
            if (this.lineBufferIdx == this.lineBuffer.length) {
                this.lineBuffer = Arrays.copyOf(this.lineBuffer, this.lineBuffer.length * 2);
            }
            this.lineBuffer[this.lineBufferIdx] = b;
            ++this.lineBufferIdx;
        }
        String line = null;
        if (!more) {
            line = new String(this.lineBuffer, 0, this.lineBufferIdx);
            this.lineBufferIdx = 0;
        }
        return line;
    }

    public final void reset() {
        this.lineBufferIdx = 0;
    }
}

