/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.httpkit.PriorityQueue;
import org.httpkit.client.IRespListener;
import org.httpkit.client.Request;
import org.httpkit.client.RequestConfig;

public class HttpsRequest
extends Request {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    SSLEngine engine;
    private ByteBuffer myNetData = ByteBuffer.allocate(40960);
    private ByteBuffer peerNetData = ByteBuffer.allocate(40960);
    boolean handshaken = false;

    public HttpsRequest(InetSocketAddress addr, ByteBuffer[] request, IRespListener handler, PriorityQueue<Request> clients, RequestConfig config, SSLEngine engine) {
        super(addr, request, handler, clients, config);
        this.engine = engine;
    }

    final int unwrapRead(ByteBuffer peerAppData) throws IOException {
        int read = ((SocketChannel)this.key.channel()).read(this.peerNetData);
        int unwrapped = 0;
        if (read > 0) {
            SSLEngineResult res;
            this.peerNetData.flip();
            while ((res = this.engine.unwrap(this.peerNetData, peerAppData)).getStatus() == SSLEngineResult.Status.OK) {
                unwrapped += res.bytesProduced();
                if (this.peerNetData.hasRemaining()) continue;
            }
            this.peerNetData.compact();
            switch (res.getStatus()) {
                case OK: 
                case BUFFER_UNDERFLOW: {
                    return unwrapped;
                }
                case CLOSED: {
                    return unwrapped > 0 ? unwrapped : -1;
                }
                case BUFFER_OVERFLOW: {
                    return -1;
                }
            }
            return unwrapped;
        }
        return read;
    }

    private void wrapRequest() throws SSLException {
        this.myNetData.clear();
        SSLEngineResult res = this.engine.wrap(this.request, this.myNetData);
        if (res.getStatus() != SSLEngineResult.Status.OK) {
            // empty if block
        }
        this.myNetData.flip();
    }

    final void writeWrappedRequest() throws IOException {
        if (this.myNetData.hasRemaining()) {
            ((SocketChannel)this.key.channel()).write(this.myNetData);
        } else if (this.request[this.request.length - 1].hasRemaining()) {
            this.wrapRequest();
            ((SocketChannel)this.key.channel()).write(this.myNetData);
        }
        if (this.myNetData.hasRemaining() || this.request[this.request.length - 1].hasRemaining()) {
            if ((this.key.interestOps() & 4) == 0) {
                this.key.interestOps(4);
            }
        } else {
            this.key.interestOps(1);
        }
    }

    final int doHandshake(ByteBuffer peerAppData) throws IOException {
        SSLEngineResult.HandshakeStatus hs = this.engine.getHandshakeStatus();
        while (!this.handshaken) {
            block0 : switch (hs) {
                case NEED_TASK: {
                    Runnable runnable;
                    while ((runnable = this.engine.getDelegatedTask()) != null) {
                        runnable.run();
                    }
                    break;
                }
                case NEED_UNWRAP: {
                    int read = ((SocketChannel)this.key.channel()).read(this.peerNetData);
                    if (read < 0) {
                        return -1;
                    }
                    this.peerNetData.flip();
                    SSLEngineResult res = this.engine.unwrap(this.peerNetData, peerAppData);
                    this.peerNetData.compact();
                    switch (res.getStatus()) {
                        case BUFFER_OVERFLOW: {
                            break block0;
                        }
                        case CLOSED: {
                            return -1;
                        }
                        case BUFFER_UNDERFLOW: {
                            return 0;
                        }
                    }
                    break;
                }
                case NEED_WRAP: {
                    SSLEngineResult res = this.engine.wrap(EMPTY_BUFFER, this.myNetData);
                    this.myNetData.flip();
                    ((SocketChannel)this.key.channel()).write(this.myNetData);
                    if (this.myNetData.hasRemaining()) break;
                    this.myNetData.clear();
                    if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
                    this.key.interestOps(1);
                }
            }
            hs = this.engine.getHandshakeStatus();
            boolean bl = this.handshaken = hs == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || hs == SSLEngineResult.HandshakeStatus.FINISHED;
            if (!this.handshaken) continue;
            this.wrapRequest();
            this.writeWrappedRequest();
        }
        return 0;
    }

    @Override
    public void recycle(Request old) throws SSLException {
        super.recycle(old);
        this.engine = ((HttpsRequest)old).engine;
        this.handshaken = true;
        this.wrapRequest();
    }
}

