(defproject edocu/http-kit "2.1.18.10"
  :description "High-performance event-driven HTTP client/server for Clojure"
  :dependencies [[org.clojure/clojure "1.7.0"]
                 [edocu/clj-edocu-cache "0.1.12"]
                 [selmeci/core.async "0.1.1"]
                 [pandect "0.5.3"]
                 [cheshire "5.5.0"]
                 [com.taoensso/timbre "4.1.1"]]
  :warn-on-reflection true
  :min-lein-version "2.0.0"
  :url "https://github.com/infones/clj-eDocu-cache"
  :javac-options ["-source" "1.6" "-target" "1.6" "-g"]
  :java-source-paths ["src/java"]
  :test-paths ["test"]
  :jar-exclusions [#".*java$"]
  :plugins [[lein-swank "1.4.4"]]
  :test-selectors {:default (complement :benchmark)
                   :benchmark :benchmark
                   :all (fn [_] true)}
  :license {:name "Apache License, Version 2.0"
            :url "http://www.apache.org/licenses/LICENSE-2.0.html"}
  :jvm-opts ["-Dclojure.compiler.disable-locals-clearing=true"
             "-Xms1g" "-Xmx1g"]         ; test https require more memory
  :profiles {:1.5 {:dependencies [[org.clojure/clojure "1.5.1"]]}
             :test {:java-source-paths ["test/java" "src/java"]}
             :dev {:dependencies [[junit/junit "4.12"]
                                  [org.clojure/tools.logging "0.3.1"]
                                  [ch.qos.logback/logback-classic "1.1.3"]
                                  [clj-http "2.0.0"]
                                  [io.netty/netty "4.0.0.Alpha8"]
                                  [org.clojure/data.json "0.2.6"]
                                  [http.async.client "0.6.1"]
                                  [compojure "1.4.0"]
                                  [org.clojure/tools.cli "0.3.3"]
                                  [ring/ring-jetty-adapter "1.4.0"]
                                  [ring/ring-core "1.4.0"]]}})
