(ns com.edocu.elements.type.http
  (:require [org.httpkit.client :as http]
            [com.edocu.configuration.core :as config]
            [com.edocu.help.rest :refer [options]]
            [cheshire.core :as json]
            [clojure.tools.logging :as log]
            [com.edocu.help.sentry :as sentry]
            [clojure.core.async :refer [go >! close!]]))

(defn element-structure [element_type response_channel]
  (let [base_url (format "%s/%s"
                         (config/ELEMENT_STRUCTURE)
                         (:type_id element_type))]
    (http/get base_url
              {}
              (fn [{:keys [status body error]}]
                (sentry/put-in-mdc {"base_url"     base_url
                                    "service"      "Editors"
                                    "error"        error
                                    "element_type" element_type
                                    "status"       status})
                (if error
                  (do
                    (log/error "Error from Editors on element type structure." error)
                    (close! response_channel))
                  (if (> status 200)
                    (log/error "Element type does not exists.")
                    (try
                      (let [structure (json/parse-string body true)]
                        (log/trace "element-structure:" "element_type:" element_type "structure:" structure)
                        (go (>! response_channel structure)
                            (close! response_channel)))
                      (catch Exception e
                        (sentry/put-in-mdc "body" body)
                        (log/error e "Invalid response from Editors on element type structure.")
                        (close! response_channel)))))))))

