(ns com.edocu.elements.type.protocols)

(defrecord ElementTypes [])

(def ->ElementTypes (memoize ->ElementTypes))

(defrecord ElementType [type_id
                        structure_delay]
  Object
  (toString [this] (pr-str this)))

(defprotocol Global
  (lazy->ElementType [global type_id] "Return lazy ElementType object"))

(defprotocol TypeManager
  (structure [element_type] "Return channel with element type structure")
  (file-attributes [element_type] "Return channel with set of file attributes")
  (text-attributes [element_type] "Return channel with set of text attributes")
  (dropdown-attributes [element_type] "Return channel with set of dropdown attributes")
  (text-area-attributes [element_type] "Return channel with set of textarea attributes")
  (date-time-attributes [element_type] "Return channel with set of date attributes"))