(ns com.edocu.users.configuration
  (:require [environ.core :as e]))

(def ENV (promise))

(defn env []
  (if-not (realized? ENV)
    (deliver ENV (or
                   (keyword (e/env :env))
                   :dev)))
  @ENV)

(defn ^String USER_PRIVILEGES_IN_ELEMENT [element_hash]
  (format "%s%s"
          "http://nugeta/user-privileges/in-element/"
          element_hash))

(defn ^String USER_ORGANIZATIONS []
  "http://api-old/users/organizations")

(defn ^String NUGETA_SERVICE []
  "http://nugeta")

(defn ^String USER_PRIVILEGES_IN_ORGANIZATION_FOR_ELEMENT_TYPE [organization_uid element_type_uid]
  (format "%s/user-privileges/%s/%s"
          (NUGETA_SERVICE)
          organization_uid
          element_type_uid))

(defn ^String ELEMENT_TYPES_WITH_PRIVILEGES_IN_ORGANIZATION [user_id organization_id privileges]
  (format "%s/user-privileges/%s/%s/element-types?privs=%s"
          (NUGETA_SERVICE)
          organization_id
          user_id
          privileges))

(defn ^String READABLE_ATTRIBUTES_URL []
  (format "%s/readable" (NUGETA_SERVICE)))

(defn ^String UPDATEABLE_ATTRIBUTES_URL []
  (format "%s/updateable" (NUGETA_SERVICE)))

(defn ^String CREATEABLE_ATTRIBUTES_URL []
  (format "%s/createable" (NUGETA_SERVICE)))

(defn ^String CREATE_USER []
  "http://users")

(defn ^String USERS_INFO_ABOUT
  []
  (str (CREATE_USER) "/info-about"))

(def ^:const ^String USER_CREATE_CONTENT_TYPE "application/vnd.edocu.user.v0.0.1+json")
(def ^:const ^String USER_INFO_ABOUT_CONTENT_TYPE "application/vnd.edocu.users.info-about.v1+json")

(def ^:const ^Integer RESPONSE_TIME 10000)

(defn ^String CHECK_USER_IN_SECURITY_GROUP
  ([^String user_id ^String security_group_id]
   (format "%s/security-groups/%s/users/%s"
           (NUGETA_SERVICE)
           security_group_id
           user_id))
  ([^String user_id ^String organization_id ^String title]
   (format "%s/security-groups/%s/%s/users/%s"
           (NUGETA_SERVICE)
           organization_id
           title
           user_id)))
