(ns com.edocu.users.help.rest
  (:require [com.edocu.users.protocols :as users]))

(def ^:private USER_PATH [:request :headers "uid"])

(defn construct-user [ctx]
  (users/lazy->User (users/->Users) (or
                                      (get-in ctx USER_PATH)
                                      "ThieftEdoduWarning")))

(defn authorized? [ctx]
  [(not (nil? (get-in ctx USER_PATH)))
   {:user (construct-user ctx)}])

