(ns com.edocu.users.protocols)

(def ^:const ^String OPEN_USER_UID "open")

(defrecord Users [])

(def ->Users (memoize ->Users))

(defrecord User [uid cn sn mail mobile preferredLanguage password])
(defrecord OpenUser [uid cn sn mail mobile preferredLanguage password])

(defrecord Privileges [type_privileges attribute_privileges])

(defprotocol Global
  (lazy->User [global uid] "Return lazy instantion of User")
  (create->User [global author_uid uid cn sn mail mobile preferredLanguage password] "Return channel with user object if created"))

(defprotocol Privilege
  (organizations [this] "Return channel with user's organizations")
  (privileges-in-organization 
    [this organization ^String element_type]
    [this organization ^String element_type attribute_filter?] "Return channel with user privilege in organization for element type")
  (privileges-in-element 
    [this edocu_element]
    [this edocu_element attribute_filter?] "Return channel with user privileges in element")
  (belongs-to-security-group
    [this ^String security_group_id]
    [this ^String organization_id ^String title] "Return channel with true if user belongs to organization. Otherwise false"))