(ns com.edocu.help.memo
  (:require [clojure.core.async :refer [chan go >! <! close!]]))

(defn init-memo-storage [this]
  (with-meta this {:memo (atom {})}))

(defmacro with-memo [this k original_fn]
  `(let [result# (chan)]
     (go
       (if-let [in_memo# (get @(:memo (meta ~this)) ~k)]
         (if in_memo#
           (>! result# in_memo#)
           (close! result#))
         (let [tmp# (chan)]
           (~original_fn
             tmp#)
           (let [original_result# (<! tmp#)]
             (swap! (:memo (meta ~this)) assoc ~k original_result#)
             (if original_result#
               (>! result# original_result#)
               (close! result#))))))
     result#))

(defprotocol Hi
  (hi [this name] "Return hi"))

(defprotocol Poo
  (poo [this name] "Return poo"))

(defrecord World [n])

(defn sk-hi [n]
  (let [impl-hi {:hi (fn [this name]
                    (println "Ahoj: " name "in: " this))}
        impl-poo {:poo (fn [this name]
                         (println "Prd:" name "in: " this))}
        w (->World n)]
    (reify
      Hi
      (hi [_ name] (apply (:hi impl-hi) [w name]))
      Poo
      (poo [_ name] (apply (:poo impl-poo) [w name])))))

(defn eng-hi [n]
  (let [impl-hi {:hi (fn [this name]
                       (println "Hello: " name "in: " this))}
        impl-poo {:poo (fn [this name]
                         (println "Poo:" name "in: " this))}
        w (->World n)]
    (reify
      Hi
      (hi [_ name] (apply (:hi impl-hi) [w name]))
      Poo
      (poo [_ name] (apply (:poo impl-poo) [w name])))))

(defmacro def-in-instance [name impls]
  (let [reify_definition (reduce
                           (fn [tmp [prot methods]]
                             (-> tmp
                                 (into [(symbol prot)])
                                 (into (map
                                         (fn [[fnn {:keys [args f]}]]
                                           (list (symbol fnn)
                                                 (into [(symbol "this")] args)
                                                 `(apply ~f  ~(into [(symbol "obj")] args))))
                                         methods))))
                           []
                           impls)]
    `(defn ~(symbol name) [~(symbol "obj")]
       (reify
         ~@reify_definition))))