(ns com.edocu.help.saver
  (:require [clojure.core.async :refer [<! go go-loop chan sub close!]]))

(defmacro def-saver [callback]
  `(defn ~'saver []
     (let [result# (chan )]
       (go
         (~callback (<! result#))
         (close! result#))
       result#)))

(defmacro def-listener [publisher event callback]
  `(def ~'listener (let [listener_c# (chan 128)]
                     (sub ~publisher ~event listener_c#)
                     (go-loop [[_ data#] (<! listener_c#)]
                              (if data#
                                (do
                                  (~callback data#)
                                  (recur (<! listener_c#)))))
                     listener_c#)))