(ns com.edocu.help.time
  (:require [clj-time.coerce :as c]
            [clj-time.local :as l])
  (:import org.joda.time.DateTimeZone
           org.joda.time.DateTime))

(DateTimeZone/setDefault DateTimeZone/UTC)

(defn now-timestamp []
  (int (/ (c/to-long (l/local-now)) 1000)))

(defn datetime? [datetime]
  (instance? DateTime datetime))

(defn now-datetime [& [datetime]]
  (if (datetime? datetime)
    datetime
    (l/local-now)))

(defn datetime-to-timestamp [datetime]
  (int (/ (c/to-long datetime) 1000)))

(defn parse-to-date-time [date_time_str]
  (.toDate (l/to-local-date-time date_time_str)))

