(ns com.edocu.help.memo
  (:require [clojure.core.async :refer [chan go >! <! close!]]))

(defn init-memo-storage [this]
  (with-meta this {:memo (atom {})}))

(defmacro with-memo [this k original_fn]
  `(let [result# (chan )]
     (go
       (if (contains? @(:memo (meta ~this)) ~k)
         (if-let [in_memo# (get @(:memo (meta ~this)) ~k)]
           (>! result# in_memo#)
           (close! result#))
         (let [tmp# (chan )]
           (~original_fn
             tmp#)
           (if-let [original_result# (<! tmp#)]
             (do
               (swap! (:memo (meta ~this)) assoc ~k original_result#)
               (>! result# original_result#))
             (close! result#)))))
     result#))