(ns com.edocu.help.sentry
  (:require [ring.util.response :as ring-res]
            [com.edocu.users.protocols :as users])
  (:import [org.slf4j MDC]))

(defmacro put-in-mdc
  ([kvs]
   `(do
      ;(MDC/clear)
      ~@(map (fn [[k v]] `(put-in-mdc ~k ~v)) kvs)))
  ([key value]
   `(MDC/put (str ~key) (pr-str ~value))))

(defn wrap-sentry-user
  "Returns a Ring middleware handler that add user uid do sentry context"
  [handler]
  (fn [request]
    (let [user-uid (or
                     (ring-res/get-header request "uid")
                     users/OPEN_USER_UID)]
      (MDC/put "User" user-uid)
      (handler request))))
