(ns com.edocu.help.cache)

(defmacro def-impl-fn [prot f]
  `(fn ~(into ['this] (:args f))
     (let [impl# (get-in (meta ~(symbol "this")) [:impl ~prot])]
       (apply (~(:name f) impl#) ~(into ['this] (:args f))))))

(defmacro in-meta-impl [prot fns]
  (reduce
    (fn [tmp f]
      (assoc tmp
        (:name f)
        `(def-impl-fn ~prot ~f)))
    {}
    fns))