(ns com.edocu.configuration.persistence.mongodb
  (:require [com.edocu.configuration.core :refer [mongodb-replicas-uri mongodb-db env]]
            [monger
             [core :as mg]
             [credentials :as mcred]]
            [clojure.tools.logging :as log]
            [environ.core :as e])
  (:import [com.mongodb MongoOptions]))

(defn- mg-connect-args []
  (let [^MongoOptions opts (mg/mongo-options [:threads-allowed-to-block-for-connection-multiplier 300])]
    (into [(map #(mg/server-address (:uri %) (:port %)) (mongodb-replicas-uri))
           opts]
          (if (and (e/env :mongodb-username)
                   (e/env :mongodb-password))
            [(mcred/create
               (e/env :mongodb-username)
               (mongodb-db)
               (e/env :mongodb-password))]
            []))))

(defn connect! []
  (log/trace "MongoDB connect!:" "addresses:" (mongodb-replicas-uri) "database:" (mongodb-db))
  (let [conn (apply mg/connect (mg-connect-args))
        _db (mg/get-db conn (mongodb-db))]
    _db))

(def db (delay (connect!)))

(def ^:private index-setup (atom []))

(defn add-index-to-setup! [setup_fn]
  (swap! index-setup conj setup_fn))

(defn init-indexes []
  (doseq [ind @index-setup]
    (ind))
  (reset! index-setup []))


