(ns com.edocu.configuration.constants)

(def ^:const ^String ETCD_DEFAULT_URL "etcd.db.dev.edocu.local")
(def ^:const ^String CONFIG_KEY_PREFIX "/edocu/config/")

;; PATHS

(def ^:const ^String BASE_URL_PATH "base-url")
(def ^:const ^String EMAIL_PREFIX "email/")
(def ^:const ^String SMTP_PATH (str EMAIL_PREFIX "smtp"))
(def ^:const ^String NOTIFICATION_EMAIL_PATH (str EMAIL_PREFIX "addresses/notifications"))
(def ^:const ^String CLJ_PREFIX "clj/")
(def ^:const ^String KAFKA_PREFIX "kafka/")
(def ^:const ^String KAFKA_BROKERS_PATH (str KAFKA_PREFIX "brokers"))
(def ^:const ^String ZOOKEPER_SERVERS_PATH "zookeeper/servers")
(def ^:const ^String ROUTER_PREFIX "router/")
(def ^:const ^String TOPICS_PREFIX (str ROUTER_PREFIX "topics/"))
(def ^:const ^String CBR_TOPIC_PATH (str TOPICS_PREFIX "cbr"))
(def ^:const ^String REGISTER_TOPIC_PATH (str TOPICS_PREFIX "register"))
(def ^:const ^String SERVICE_ERROR_TOPIC_PATH (str TOPICS_PREFIX "service-error"))
(def ^:const ^String MALFORMED_MESSAGE_TOPIC_PATH (str TOPICS_PREFIX "malformed-message"))
(def ^:const ^String PERSISTENCE_PREFIX "persistence/")
(def ^:const ^String REDIS_HOST_PATH (str CLJ_PREFIX PERSISTENCE_PREFIX "redis/host"))
(def ^:const ^String MONGODB_PREFIX (str CLJ_PREFIX PERSISTENCE_PREFIX "mongodb/"))
(def ^:const ^String MONGODB_REPLICAS_URI_PATH (str MONGODB_PREFIX "replicas-uri"))
(def ^:const ^String MONGODB_DB_PATH (str MONGODB_PREFIX "db"))
(def ^:const ^String INTEGRATION_ENV_PATH "integration/env")
(def ^:const ^String ZEROMQ_PATH "zeromq/")
(def ^:const ^String ZEROMQ_ROUTER_ADDRESS_PATH (str ZEROMQ_PATH "router-address"))
(def ^:const ^String ZEROMQ_PUBLISHER_ADDRESS_PATH (str ZEROMQ_PATH "publisher-address"))

;; ############################################################################################

;; DEFAULTS

(def ^:const ^String REDIS_HOST "redis.db.dev.edocu.local")
(def ^:const ^Byte REDIS_DB 8)
(def ^:const ^String BASE_URL_DEFAULT "https://edocu.service.dev.edocu.local")
(def ^:const ^String SMTP_DEFAULT "")
(def ^:const ^String NOTIFICATION_EMAIL_DEFAULT "notifications@edocu.eu")
(def ^:const ^String ZOOKEPER_SERVERS_DEFAULT ["zookeeper.service.dev.edocu.local:2181"])
(def ^:const ^String KAFKA_BROKERS_DEFAULT ["1.kafka.mq.dev.edocu.local:9092"])
(def ^:const KAFKA_ZOOKEEPER_DEFAULT {:servers ZOOKEPER_SERVERS_DEFAULT})
(def ^:const ^String CBR_TOPIC_DEFAULT "system.router")
(def ^:const ^String REGISTER_TOPIC_DEFAULT "system.router.register-topic")
(def ^:const ^String SERVICE_ERROR_TOPIC_DEFAULT "system.errors.service")
(def ^:const ^String MALFORMED_MESSAGE_TOPIC_DEFAULT "system.errors.message.malformed")
(def ^:const ^String INTEGRATION_ENV "no")
(def ^:const ^String ZEROMQ_ROUTER_ADDRESS_DEFAULT "tcp://cbr.service.dev.edocu.local:60001")
(def ^:const ^String ZEROMQ_PUBLISHER_ADDRESS_DEFAULT "tcp://cbr.service.dev.edocu.local:60002")