(ns com.edocu.sentry.core
  (:require [environ.core :as e]
            [raven-clj.core :as raven]
            [raven-clj.ring :as raven-ring]
            [raven-clj.interfaces :as interfaces]))

(def sentry-dsn (delay (e/env :sentry-dsn)))

(defn sentry-capture [service release message error]
  (raven/capture @sentry-dsn
                 (-> {:message message
                      :release release
                      :tags    {:service service}}
                     (interfaces/stacktrace error))))

(defn sentry-wrapper [service release handler]
  (raven-ring/wrap-sentry handler
                          @sentry-dsn
                          {:extra {:release release
                                   :tags    {:service service}}}))
