(ns ^:figwheel-always cljs.com.edocu.configuration.core
  (:require [cljs.com.edocu.configuration.etcd :as etcd]
            [taoensso.timbre :as timbre]
            [com.edocu.configuration.constants :as const]))

(defn- with-default
  ([path default]
   (with-default
     path
     default
     identity))
  ([path default data_parser]
   (if-let [data (etcd/get-config-for
                   path)]
     (data_parser data)
     default)))

;############################ Base URL ###############################

(def base-url-atom (atom nil))

(defn ^:export base-url []
  (when-not @base-url-atom
    (reset! base-url-atom
            (with-default
              const/BASE_URL_PATH
              const/BASE_URL_DEFAULT))
    (timbre/trace "base-url" @base-url-atom))
  @base-url-atom)

;######################################################################

;###################### Zookeepers Servers ############################

(def zookeepers-servers-atom (atom nil))

(defn ^:export zookeepers-servers []
  (when-not @zookeepers-servers-atom
    (reset! zookeepers-servers-atom
            (with-default
              const/ZOOKEPER_SERVERS_PATH
              const/ZOOKEPER_SERVERS_DEFAULT))
    (timbre/trace "zookeepers-servers" @zookeepers-servers-atom))
  @zookeepers-servers-atom)

;######################################################################

;######################## Kafka Brokers ###############################

(def kafka-zookeeper-atom (atom nil))

(defn ^:export kafka-zookeeper []
  (when-not @kafka-zookeeper-atom
    (reset! kafka-zookeeper-atom
            (with-default
              const/KAFKA_ZOOKEEPER_PATH
              const/KAFKA_ZOOKEEPER_DEFAULT))
    (timbre/trace "kafka-zookeeper" @kafka-zookeeper-atom))
  @kafka-zookeeper-atom)

;######################################################################

;############################ CBR topis ###############################

(def cbr-topic-atom (atom nil))

(defn ^:export cbr-topic []
  (when-not @cbr-topic-atom
    (reset! cbr-topic-atom
            (with-default
              const/CBR_TOPIC_PATH
              const/CBR_TOPIC_DEFAULT))
    (timbre/trace "cbr-topic" @cbr-topic-atom))
  @cbr-topic-atom)

;######################################################################

;########################## Register topis ############################

(def register-topic-atom (atom nil))

(defn ^:export register-topic []
  (when-not @register-topic-atom
    (reset! register-topic-atom
            (with-default
              const/REGISTER_TOPIC_PATH
              const/REGISTER_TOPIC_DEFAULT))
    (timbre/trace "register-topic" @register-topic-atom))
  @register-topic-atom)

;######################################################################

;########################## Register topis ############################

(def service-error-topic-atom (atom nil))

(defn ^:export service-error-topic []
  (when-not @service-error-topic-atom
    (reset! service-error-topic-atom
            (with-default
              const/SERVICE_ERROR_TOPIC_PATH
              const/SERVICE_ERROR_TOPIC_DEFAULT))
    (timbre/trace "service-error-topic" @service-error-topic-atom))
  @service-error-topic-atom)

;######################################################################

;########################## Register topis ############################

(def malformed-message-topic-atom (atom nil))

(defn ^:export malformed-message-topic []
  (when-not @malformed-message-topic-atom
    (reset! malformed-message-topic-atom
            (with-default
              const/MALFORMED_MESSAGE_TOPIC_PATH
              const/MALFORMED_MESSAGE_TOPIC_DEFAULT))
    (timbre/trace "malformed-message-topic" @malformed-message-topic-atom))
  @malformed-message-topic-atom)

;######################################################################

(defn -main []
  )

(set! cljs.core/*main-cli-fn* -main)

(set! (.-exports js/module) #js {:base-url base-url})
(set! (.-exports js/module) #js {:zookeepers-servers zookeepers-servers})
(set! (.-exports js/module) #js {:kafka-zookeeper kafka-zookeeper})
(set! (.-exports js/module) #js {:cbr-topic cbr-topic})
(set! (.-exports js/module) #js {:register-topic register-topic})
(set! (.-exports js/module) #js {:service-error-topic service-error-topic})
(set! (.-exports js/module) #js {:malformed-message-topic malformed-message-topic})