(defproject edocu/clj-edocu-configuration "0.1.2-SNAPSHOT"
  :description "Small lib for configuration management for clojure services"
  :url "https://bitbucket.org/edocu/clj-edocu-configuration"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :dependencies [[org.clojure/clojure "1.7.0"]
                 [com.taoensso/timbre "4.1.4"]
                 [environ "1.0.1"]
                 [etcd-clojure "0.2.3" :exclusions [potemkin clj-tuple riddley]]
                 [clojurewerkz/urly "1.0.0" :exclusions [com.google.guava/guava]]
                 [cheshire "5.5.0"]
                 [com.novemberain/monger "3.0.1"]
                 [org.clojure/clojurescript "1.7.170"]
                 [org.clojure/core.async "0.2.374" :exclusions [org.clojure/tools.reader]]]

  :npm {:dependencies [[node-etcd "4.2.1"]
                       [source-map-support "0.4.0"]]}

  :plugins [[lein-cljsbuild "1.1.1"]
            [lein-npm "0.6.1"]
            [lein-figwheel "0.5.0-2"]]

  :cljsbuild {:builds [{:id           "configuration"
                        :source-paths ["src"]
                        ;:figwheel true
                        :compiler     {
                                       :main           cljs.com.edocu.configuration.core
                                       :output-to      "edocu-configuration.js"
                                       :output-dir     "target/js"
                                       :optimizations  :simple
                                       :cache-analysis true
                                       ;:source-map     true
                                       :target         :nodejs
                                       :pretty-print   true}}]}

  :clean-targets ^{:protect false} [:target-path "target/js"]

  :profiles {:dev {:dependencies [[midje "1.8.2"]]
                   :plugins [[lein-midje "3.1.3"]]}})
