(defproject edocu/clj-communication "0.1.9"
  :description "Library with clients for communication among services in eDocu"
  :license "MIT"
  :url "https://bitbucket.org/edocu/clj-edocu-communication"

  :min-lein-version "2.7.1"

  :aot :all

  :dependencies [[org.clojure/clojure "1.9.0-alpha16"]
                 [org.clojure/clojurescript "1.9.671"]
                 [org.clojure/core.async "0.3.443" :exclusions [org.clojure/tools.reader]]
                 [org.clojure/core.memoize "0.5.9"]
                 [org.clojure/tools.logging "0.4.0"]
                 [com.taoensso/timbre "4.10.0"]
                 [potemkin "0.4.3"]
                 [ymilky/franzy "0.0.1"]
                 [ymilky/franzy-admin "0.0.1"]
                 [ymilky/franzy-json "0.0.1"]
                 [environ "1.1.0"]
                 [cheshire "5.7.1"]
                 [edocu/clj-edocu-configuration "0.1.8" :exclusions [edocu/clj-edocu-help]]
                 [edocu/clj-edocu-help "0.1.12"]]

  :npm {:dependencies [[dotenv "4.0.0"]
                       [ws "2.2.2"]
                       [kafka-node "1.6.1"]]}

  :plugins [[lein-figwheel "0.5.10"]
            [lein-npm "0.6.2"]
            [lein-cljsbuild "1.1.5" :exclusions [[org.clojure/clojure]]]]

  :source-paths ["src"]

  :clean-targets ^{:protect false} ["target"]

  :cljsbuild {:builds
              [{:id           "server-dev"
                :source-paths ["src"]
                :figwheel     true
                :compiler     {:main          com.edocu.communication.core
                               :output-to     "target/server_dev/communication.js"
                               :output-dir    "target/server_dev"
                               :target        :nodejs
                               :language-in   :ecmascript5
                               :pretty-print  true
                               :optimizations :none
                               :source-map    true}}
               {:id           "nodejs"
                :source-paths ["src"]
                :compiler     {:main          com.edocu.communication.core
                               :output-to     "target/nodejs/communication.js"
                               :target        :nodejs
                               :optimizations :simple}}]}

  :figwheel {}

  :profiles {:dev {:dependencies  [[org.clojure/test.check "0.9.0"]
                                   [binaryage/devtools "0.9.4"]
                                   [figwheel-sidecar "0.5.11"]
                                   [com.cemerick/piggieback "0.2.2"]]
                   ;; need to add dev source path here to get user.clj loaded
                   :source-paths  ["src" "dev"]
                   ;; for CIDER
                   ;; :plugins [[cider/cider-nrepl "0.12.0"]]
                   :repl-options  {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}
                   ;; need to add the compliled assets to the :clean-targets
                   :clean-targets ^{:protect false} [:target-path]}})