(ns com.edocu.communication.kafka.config
  (:require [com.edocu.configuration.core :as config]
            [franzy.admin.zookeeper.client :as client]
            [franzy.admin.zookeeper.defaults :as zk-defaults]))

(def is-secure? false)

(def default-partition-count 3)
(def default-replication-factor 1)

(defn zk-config []
  {:servers (config/zookeepers-servers)})

(defn make-zk-config []
  (merge (zk-defaults/zk-client-defaults)) (zk-config))

(defn make-zk-client []
  (client/make-zk-client (make-zk-config)))

(defn make-zk-utils []
  (client/make-zk-utils (make-zk-config) is-secure?))

(def default-group-id "edocu")



