(ns com.edocu.communication.kafka.core
  (:use com.edocu.communication.protocols)
  (:require [taoensso.timbre :as timbre]
            [clj-kafka.new.producer :as kafka-producer]
            [clj-kafka.consumer.zk :as kafka-consumer]
            [clj-kafka.core :as kafka-core]
            [com.edocu.configuration.core :as config]
            [clojure.core.async :refer [>!!]]))

#?(:clj (def producer-promise (promise)))
(defrecord Communicator
  #?(:clj     [consumer_config]
     :default [])

  IMessageManagement

  (route-message! [_ topic message]
    (timbre/debug "route-message!:" "topic:" topic "message:" message)
    #?(:clj     (kafka-producer/send
                   @producer-promise
                   (kafka-producer/record
                     topic
                     (.getBytes (:topic message))
                     (message-body message)))
        :default ((timbre/error "route-message!: Not implemented"))))

  (send-message! [communicator topic message]
    (timbre/debug "send-message!:" "topic:" topic "message:" message)
    (route-message!
      communicator
      (config/cbr-topic)
      (create->SendMessage
        topic
        message)))

  ITopicManagement

  (register-topics! [communicator topics]
    (timbre/debug ":register-topic!" "topics:" topics)
    (send-message!
      communicator
      (config/register-topic)
      {:topic topics}))

  (subscribe-to-topic [comminicator topic callback_chan]
    #?(:clj     (future
                   (kafka-core/with-resource
                     [c (kafka-consumer/consumer
                          (merge
                            (config/kafka-zookeeper)
                            (:consumer_config comminicator)))]
                     kafka-consumer/shutdown
                     (doseq [{:keys [key value]} (kafka-consumer/messages c topic)]
                       (>!! callback_chan
                            (create->ReceiveMessage
                              (String. key)
                              value)))))
        :default ((timbre/error "subscribe-to-topic: Not implented"))))

  IErrorsManagement

  (send-malformed-message-report! [communicator message]
    (send-message!
      communicator
      (config/malformed-message-topic)
      message))

  (send-service-error-report! [communicator message]
    (send-message!
      communicator
      (config/malformed-message-topic)
      message)))