(defproject edocu/clj-communication "0.1.11-SNAPSHOT"
  :description "Library with clients for communication among services in eDocu"
  :license "MIT"
  :url "https://bitbucket.org/edocu/clj-edocu-communication"

  :min-lein-version "2.7.1"

  :aot :all

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/clojurescript "1.10.339"]
                 [org.clojure/core.async "0.4.474"]
                 [org.clojure/core.memoize "0.7.1"]
                 [org.clojure/tools.logging "0.4.1"]
                 [com.taoensso/timbre "4.10.0"]
                 [potemkin "0.4.5"]
                 [ymilky/franzy "0.0.1"]
                 [ymilky/franzy-admin "0.0.1"]
                 [ymilky/franzy-json "0.0.1"]
                 [environ "1.1.0"]
                 [cheshire "5.8.1"]
                 [edocu/clj-edocu-configuration "0.1.9-SNAPSHOT" :exclusions [edocu/clj-edocu-help
                                                                              org.mongodb/mongodb-driver-async
                                                                              io.netty/netty-all]]
                 [edocu/clj-edocu-help "0.1.14-SNAPSHOT"]
                 [com.stuartsierra/component "0.3.2"]]

  :npm {:dependencies [[dotenv "6.1.0"]
                       [ws "6.1.0"]
                       [winston "3.1.0"]
                       [aws-iot-device-sdk "2.2.1"]
                       [kafka-node "3.0.1"]]}

  :plugins [[lein-figwheel "0.5.14"]
            [lein-npm "0.6.2"]
            [lein-cljsbuild "1.1.7" :exclusions [[org.clojure/clojure]]]]

  :source-paths ["src"]

  :clean-targets ^{:protect false} ["target"]

  :cljsbuild {:builds
              [{:id           "server-dev"
                :source-paths ["src"]
                :figwheel     true
                :compiler     {:main          com.edocu.communication.core
                               :output-to     "target/server_dev/communication.js"
                               :output-dir    "target/server_dev"
                               :target        :nodejs
                               :language-in   :ecmascript5
                               :pretty-print  true
                               :optimizations :none
                               :source-map    true}}
               {:id           "nodejs"
                :source-paths ["src"]
                :compiler     {:main          com.edocu.communication.core
                               :output-to     "target/nodejs/communication.js"
                               :target        :nodejs
                               :optimizations :simple}}]}

  :figwheel {}

  :profiles {:dev {:dependencies  [[org.clojure/test.check "0.9.0"]
                                   [binaryage/devtools "0.9.10"]
                                   [figwheel-sidecar "0.5.14"]
                                   [com.cemerick/piggieback "0.2.2"]]
                   ;; need to add dev source path here to get user.clj loaded
                   :source-paths  ["src" "dev"]
                   ;; for CIDER
                   ;; :plugins [[cider/cider-nrepl "0.12.0"]]
                   :repl-options  {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}
                   ;; need to add the compliled assets to the :clean-targets
                   :clean-targets ^{:protect false} [:target-path]}})