(ns cljs.com.edocu.log
  (:require
    [clojure.string :as clj-str]
    [cljs.nodejs :as nodejs]))

(defonce winston (nodejs/require "winston"))

(defn log
  [level & message]
  (.log winston level (clj-str/join " " message)))

(defonce info (partial log "info"))
(defonce debug (partial log "debug"))
(defonce error (partial log "error"))

(defn prepare-logger
  "Set log level according to setting from env variable"
  ([]
   (prepare-logger (or (.-LOG_LVL (.-env nodejs/process))
                       "info")))
  ([lvl]
   (set! (.-level winston)
         lvl)))
