/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.speechlet.IntentRequest;
import com.amazon.speech.speechlet.LaunchRequest;
import com.amazon.speech.speechlet.SessionEndedRequest;
import com.amazon.speech.speechlet.SessionStartedRequest;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=LaunchRequest.class), @JsonSubTypes.Type(value=IntentRequest.class), @JsonSubTypes.Type(value=SessionStartedRequest.class), @JsonSubTypes.Type(value=SessionEndedRequest.class)})
public abstract class SpeechletRequest {
    private final String requestId;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss'Z'", timezone="UTC")
    private final Date timestamp;
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    protected SpeechletRequest(String requestId, Date timestamp) {
        this.requestId = requestId;
        this.timestamp = timestamp != null ? new Date(timestamp.getTime()) : null;
    }

    public final String getRequestId() {
        return this.requestId;
    }

    public final Date getTimestamp() {
        return this.timestamp != null ? new Date(this.timestamp.getTime()) : null;
    }
}

