/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.speechlet.SpeechletRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Date;
import org.apache.commons.lang3.Validate;

@JsonTypeName(value="SessionStartedRequest")
public class SessionStartedRequest
extends SpeechletRequest {
    public static Builder builder() {
        return new Builder();
    }

    private SessionStartedRequest(Builder builder) {
        super(builder.requestId, builder.timestamp);
    }

    private SessionStartedRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="timestamp") Date timestamp) {
        super(requestId, timestamp);
    }

    public static final class Builder {
        private String requestId;
        private Date timestamp = new Date();

        private Builder() {
        }

        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder withTimestamp(Date timestamp) {
            this.timestamp = timestamp != null ? new Date(timestamp.getTime()) : null;
            return this;
        }

        public SessionStartedRequest build() {
            Validate.notBlank((CharSequence)this.requestId, (String)"RequestId must be defined", (Object[])new Object[0]);
            return new SessionStartedRequest(this);
        }
    }
}

