/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.slu;

import com.amazon.speech.slu.Slot;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public final class Intent {
    private final String name;
    private final Map<String, Slot> slots;

    public static Builder builder() {
        return new Builder();
    }

    private Intent(Builder builder) {
        this.name = builder.name;
        this.slots = Collections.unmodifiableMap(builder.slots);
    }

    private Intent(@JsonProperty(value="name") String name, @JsonProperty(value="slots") Map<String, Slot> slots) {
        this.name = name;
        this.slots = slots != null ? Collections.unmodifiableMap(slots) : Collections.emptyMap();
    }

    public String getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Slot> getSlots() {
        return this.slots;
    }

    public Slot getSlot(String name) {
        return this.slots.get(name);
    }

    public static final class Builder {
        private String name;
        private final Map<String, Slot> slots = new HashMap<String, Slot>();

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withSlots(Map<String, Slot> slots) {
            this.slots.putAll(slots);
            return this;
        }

        public Intent build() {
            Validate.notBlank((CharSequence)this.name, (String)"Intent name must be defined", (Object[])new Object[0]);
            return new Intent(this);
        }
    }
}

