(ns {{namespace}}.router
  (:require [compojure.core :refer :all]
            [compojure.route :as route]
            [ring.middleware.defaults :refer [wrap-defaults api-defaults]]
            [ring.middleware.json :refer [wrap-json-body wrap-json-response]]
            [taoensso.timbre :refer [debug]]))

(defn- make-routes
  [app]
  (routes
   (POST "/echo" request (-> request :body app ring-response/response))
   (route/not-found "Not found")))

(defn- logging-handler [handler]
  "Logs the request and response objects."
  (fn [request]
    (debug "Received request:" request)
    (let [response (handler request)]
      (debug "Sending response:" response)
      response)))

(defn app-routes [app-handler]
  "Generates compojure routes that serve requests to the provided app-handler.
   app-handler should be a handler that takes an echo request map."
  (-> app-handler
      make-routes
      wrap-json-response
      logging-handler
      (wrap-defaults api-defaults)
      wrap-json-body))
