(ns leiningen.new.echo-chamber-compojure
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files sanitize-ns]]
            [leiningen.core.main :as main]))

(def render (renderer "echo-chamber-compojure"))

(defn echo-chamber-compojure
  "Applies templating to generate a new echo-chamber-compojure project."
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)
              :namespace (sanitize-ns name)}]
    (main/info "Generating fresh 'lein new' echo-chamber-compojure project.")
    (->files data
             ["project.clj" (render "project.clj" data)]
             ["src/{{sanitized}}/app.clj" (render "app.clj" data)]
             ["src/{{sanitized}}/core.clj" (render "core.clj" data)]
             ["src/{{sanitized}}/router.clj" (render "router.clj" data)])))
