/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.sms;

import cn.org.gddsn.sms.SendSMS;
import javax.comm.PortInUseException;
import org.apache.log4j.Logger;
import org.smslib.COutgoingMessage;
import org.smslib.CService;

public class SendByModem
implements SendSMS {
    static Logger logger = Logger.getLogger(SendByModem.class);
    private String device = "/dev/cuaU0";
    private int baudRate = 9600;
    private String manufacturer = "Waveform";
    private String model = "";
    private String simPin = "0000";
    private String simPin2 = "0000";
    private String smscNumber = "";

    public int send(String[] phones, String msg, long smID) {
        return this.send(phones, msg);
    }

    public int send(String[] phoneNumber, String message) {
        CService srv = new CService(this.device, this.baudRate, this.manufacturer, this.model);
        logger.info((Object)"Send  SMS.");
        logger.info((Object)"  Using SMSLib for Java v2.1.2");
        srv.setSimPin(this.simPin);
        srv.setSimPin2(this.simPin2);
        srv.setSmscNumber(this.smscNumber);
        while (true) {
            try {
                srv.connect();
                logger.info((Object)"Mobile Device Information: ");
                logger.info((Object)("  Manufacturer  : " + srv.getDeviceInfo().getManufacturer()));
                logger.info((Object)("  Model         : " + srv.getDeviceInfo().getModel()));
                logger.info((Object)("  Serial No     : " + srv.getDeviceInfo().getSerialNo()));
                logger.info((Object)("  IMSI          : " + srv.getDeviceInfo().getImsi()));
                logger.info((Object)("  S/W Version   : " + srv.getDeviceInfo().getSwVersion()));
                logger.info((Object)("  Battery Level : " + srv.getDeviceInfo().getBatteryLevel() + "%"));
                logger.info((Object)("  Signal Level  : " + srv.getDeviceInfo().getSignalLevel() + "%"));
            }
            catch (PortInUseException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
            break;
        }
        int i = 0;
        while (i < phoneNumber.length) {
            COutgoingMessage msg = new COutgoingMessage(phoneNumber[i], message);
            msg.setMessageEncoding(3);
            msg.setStatusReport(true);
            msg.setValidityPeriod(8);
            try {
                srv.sendMessage(msg);
                logger.info((Object)("Sent to " + phoneNumber[i]));
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        try {
            srv.disconnect();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return phoneNumber.length;
    }

    public String getFailedPhones(long smsID) {
        return null;
    }

    public static void main(String[] args) {
        SendByModem sm = new SendByModem();
        sm.setDevice(args[0]);
        sm.setBaudRate(Integer.parseInt(args[1]));
        String[] phs = new String[args.length - 2];
        int i = 0;
        while (i < phs.length) {
            phs[i] = args[i + 2];
            ++i;
        }
        sm.send(phs, "Hello, \u6d4b\u8bd5");
        System.exit(0);
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getSimPin() {
        return this.simPin;
    }

    public void setSimPin(String simPin) {
        this.simPin = simPin;
    }

    public String getSimPin2() {
        return this.simPin2;
    }

    public void setSimPin2(String simPin2) {
        this.simPin2 = simPin2;
    }

    public String getSmscNumber() {
        return this.smscNumber;
    }

    public void setSmscNumber(String smscNumber) {
        this.smscNumber = smscNumber;
    }
}

