/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.sms;

import cn.org.gddsn.sms.SendSMS;
import com.jasson.mas.api.ApiException;
import com.jasson.mas.api.common.ConnectStatus;
import com.jasson.mas.api.sms.SmsApiClient;
import com.jasson.mas.api.sms.SmsApiClientHandler;
import com.jasson.mas.api.sms.SmsApiClientImpl;
import com.jasson.mas.api.sms.data.ApiSmsSendRequest;
import com.jasson.mas.api.smsapi.MsgFmt;
import com.jasson.mas.api.smsapi.Report;
import com.jasson.mas.api.smsapi.Sms;
import com.jasson.mas.api.smsapi.SmsType;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Jasson2GW
implements SendSMS {
    static Logger logger = Logger.getLogger(Jasson2GW.class);
    private SmsApiClient smsApiClient = null;
    private String gateway = "10.46.12.7";
    private String appID = "eqim";
    private String password = "EQim";
    private String xcode = "222";
    private int port = 61616;
    private StringBuffer failedPhones;
    private SmsApiClientHandler smsHandler = null;
    private ConnectStatus connectStatus;

    public void init() {
        try {
            this.smsHandler = new SmsApiClientHandlerImpl();
            this.smsApiClient = new SmsApiClientImpl(this.smsHandler, this.gateway, this.port, this.appID, this.password);
            this.smsApiClient.start();
            this.smsApiClient.setAutoConnect(false);
            this.smsApiClient.setConnectTimeout(100000);
            this.connectStatus = this.smsApiClient.getConnStatusIAGW();
            if (this.connectStatus.equals((Object)ConnectStatus.Connect)) {
                logger.info((Object)"Connect successfully.");
                logger.info((Object)String.format("Phone List Limit=%d", this.smsApiClient.getDestAddrsLimit()));
            } else if (this.connectStatus.equals((Object)ConnectStatus.Disconnect)) {
                logger.info((Object)"Disconnect.");
            } else if (this.connectStatus.equals((Object)ConnectStatus.NotConnect)) {
                logger.info((Object)"No connection.");
            } else if (this.connectStatus.equals((Object)ConnectStatus.Other)) {
                logger.info((Object)"Unknow connect stat.");
            }
        }
        catch (ApiException e) {
            logger.warn((Object)"Init failed.");
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public int send(String[] phones, String msg) {
        long smID = 1L;
        return this.send(phones, msg, smID);
    }

    public int send(String[] phones, String msg, long smsID) {
        this.init();
        if (!this.connectStatus.equals((Object)ConnectStatus.Connect)) {
            return -1;
        }
        try {
            ApiSmsSendRequest smsSendRequest = new ApiSmsSendRequest();
            ArrayList<String> list = new ArrayList<String>(phones.length);
            String[] stringArray = phones;
            int n = phones.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                list.add(p);
                ++n2;
            }
            smsSendRequest.setDestAddrs(list);
            smsSendRequest.setValidTime(10000);
            smsSendRequest.setXCode(this.xcode);
            smsSendRequest.setMessage(msg);
            smsSendRequest.setMsgFormat(MsgFmt.GB2312);
            smsSendRequest.setPriority(0);
            smsSendRequest.setType(SmsType.Long);
            smsSendRequest.setAppID(this.appID);
            smsSendRequest.setNeedReport(true);
            this.smsApiClient.sendSms(smsSendRequest);
            logger.info((Object)String.format("Sent %d phones successfully.", phones.length));
        }
        catch (ApiException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
        return 0;
    }

    public String getFailedPhones(long smsID) {
        if (this.failedPhones.length() == 0) {
            return null;
        }
        return this.failedPhones.toString();
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public String getAppID() {
        return this.appID;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getXcode() {
        return this.xcode;
    }

    public void setXcode(String xcode) {
        this.xcode = xcode;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            Jasson2GW t = new Jasson2GW();
            t.setGateway(args[0]);
            t.setAppID(args[1]);
            t.setPassword(args[2]);
            t.send(new String[]{args[3]}, args[4]);
        }
    }

    public class SmsApiClientHandlerImpl
    implements SmsApiClientHandler {
        public void notifySmsDeliveryStatus(String requestID, Report[] deliveryInfo) {
            Jasson2GW.this.failedPhones = new StringBuffer(1024);
            long now = System.currentTimeMillis();
            Report[] reportArray = deliveryInfo;
            int n = deliveryInfo.length;
            int n2 = 0;
            while (n2 < n) {
                Report r = reportArray[n2];
                if (now - r.sendTime > 600L && r.sendResult != 0 || !r.stat.equals("DELIVRD")) {
                    Jasson2GW.this.failedPhones.append(r.address);
                    Jasson2GW.this.failedPhones.append(";");
                    logger.info((Object)String.format("sms failed %s: code=%s, err=%s, detail=%s", r.address, r.stat, r.errDesc, r.detailResult));
                }
                ++n2;
            }
        }

        public void notifySmsReception(Sms message) {
        }
    }
}

