/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.seismograph;

import cn.org.gddsn.signal.cfft99.Fftfax;
import org.apache.log4j.Logger;

public class PrepFFT {
    static Logger logger = Logger.getLogger(PrepFFT.class);
    public static final int N_FAC = 30;
    public static final int N_RADIX = 3;
    public static final int FFT_EXTRA = 2;
    private static int last_nfft = 1;
    private static FACT fft_list = null;
    private static int[] prime = new int[]{2, 3, 5};

    private PrepFFT() {
    }

    private static int buildFacList(int new_nfft) {
        int i;
        FACT next;
        FACT ths;
        if (last_nfft == 1) {
            ths = fft_list = new FACT();
            ths.nfft = prime[0];
            ths.fact_power[0] = 1;
            next = ths;
            i = 1;
            while (i < 3) {
                next = next.next = new FACT();
                next.nfft = last_nfft * prime[i];
                int n = i++;
                next.fact_power[n] = next.fact_power[n] + 1;
            }
        } else {
            ths = fft_list;
            while (ths.nfft < last_nfft) {
                if (ths.next == null) {
                    logger.info((Object)String.format("buildFacList: Walked off end of list this %ld last %ld\n", ths.nfft, last_nfft));
                    if (logger.isDebugEnabled()) {
                        PrepFFT.printFacList();
                    }
                    return -2;
                }
                ths = ths.next;
            }
            if (ths.nfft != last_nfft) {
                logger.info((Object)String.format("buildFacList: last %ld does not match this %ld\n", last_nfft, ths.nfft));
                if (logger.isDebugEnabled()) {
                    PrepFFT.printFacList();
                }
                return -2;
            }
        }
        last_nfft = ths.nfft;
        while (ths.nfft <= new_nfft) {
            FACT ins_before = ths;
            i = 0;
            while (i < 3) {
                int next_nfft = last_nfft * prime[i];
                while (ins_before.next != null && ins_before.next.nfft < next_nfft) {
                    ins_before = ins_before.next;
                }
                if (ins_before.next == null || ins_before.next.nfft != next_nfft) {
                    next = new FACT();
                    next.nfft = next_nfft;
                    int j = 0;
                    while (j < 3) {
                        next.fact_power[j] = ths.fact_power[j];
                        ++j;
                    }
                    int n = i;
                    next.fact_power[n] = next.fact_power[n] + 1;
                    next.next = ins_before.next;
                    ins_before.next = next;
                }
                ++i;
            }
            ths = ths.next;
            last_nfft = ths.nfft;
        }
        return 0;
    }

    public static int prepFFT(int n, FACT[] pf) {
        int rc;
        FACT ths = new FACT();
        if (n > last_nfft && (rc = PrepFFT.buildFacList(n)) < 0) {
            return rc;
        }
        ths = fft_list;
        while ((ths.nfft < n || ths.nfft % 2 == 1) && ths.next != null) {
            ths = ths.next;
        }
        if (ths.trigs == null && PrepFFT.makeTrigs(ths) < 0) {
            return -1;
        }
        pf[0] = ths;
        return ths.nfft;
    }

    private static void printFacList() {
        FACT ths = fft_list;
        while (ths != null) {
            logger.info((Object)String.format("%6ld %2ld %2ld %2ld\n", ths.nfft, ths.fact_power[0], ths.fact_power[1], ths.fact_power[2]));
            ths = ths.next;
        }
    }

    public static void trimFacList(int n) {
        if (n >= last_nfft) {
            return;
        }
        FACT ths = fft_list;
        while (ths.nfft < n) {
            fft_list = ths.next;
            ths = null;
            ths = fft_list;
        }
    }

    private static int makeTrigs(FACT ths) {
        int ntrigs = 3 * ths.nfft / 2 + 1;
        ths.trigs = new double[ntrigs];
        ths.ifax = new int[13];
        Fftfax.fftfax(ths.nfft, ths.ifax, 0, ths.trigs, 0);
        return 0;
    }

    public static class FACT {
        public int nfft;
        public int[] fact_power = new int[3];
        public double[] trigs;
        public int[] ifax;
        public FACT next;
    }
}

