/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.seismograph;

import JSci.maths.ArrayMath;
import cn.org.gddsn.signal.ButterFilter;
import cn.org.gddsn.signal.Filter;
import cn.org.gddsn.signal.Numeric;
import cn.org.gddsn.signal.NumericProcess;
import cn.org.gddsn.signal.seismograph.HudsonResponseSpectrum;

public class MMIntensity {
    private double sr;
    private double[] iacc1;
    private double[] iacc2;

    public void setInputAcc(double[] ia1, double[] ia2, double sr) {
        this.iacc1 = new double[ia1.length];
        this.iacc2 = new double[ia2.length];
        System.arraycopy(ia1, 0, this.iacc1, 0, this.iacc1.length);
        System.arraycopy(ia2, 0, this.iacc2, 0, this.iacc2.length);
        this.sr = sr;
        this.removeMean();
    }

    public int getMMI() {
        double si = this.si();
        double a = Math.log10(si);
        if (a >= 2.22) {
            return 10;
        }
        if (a >= 1.95) {
            return 9;
        }
        if (a >= 1.74) {
            return 8;
        }
        if (a >= 0.9) {
            double pv = this.peakVel();
            double lpv = Math.log10(pv);
            if (lpv >= 0.87) {
                return 7;
            }
            return 6;
        }
        double pa = this.peakAcc();
        double lpa = Math.log10(pa);
        if (lpa >= 1.4) {
            return 5;
        }
        return 4;
    }

    private double si() {
        double b1 = 0.0;
        double b2 = 1.5707963267948966;
        int n = 25;
        double[] si = new double[n];
        double[] ab = new double[this.iacc1.length];
        int i = 0;
        while (i < n) {
            double b = b1 + (double)i * (b2 - b1) / (double)n;
            double cb = Math.cos(b);
            double sb = Math.sin(b);
            int j = 0;
            while (j < ab.length) {
                ab[j] = this.iacc1[j] * cb + this.iacc2[j] * sb;
                ++j;
            }
            si[i] = this.si(ab, this.sr);
            ++i;
        }
        return ArrayMath.max((double[])si);
    }

    private double si(double[] a, double sr) {
        double z = 0.2;
        double t1 = 2.5;
        double t2 = 0.1;
        int n = 25;
        double[] rvel = new double[n];
        HudsonResponseSpectrum hrs = new HudsonResponseSpectrum();
        hrs.setInputAcc(a, sr);
        double step = (t1 - t2) / (double)n;
        int i = 0;
        while (i < n) {
            double t = t1 - (double)i * step;
            rvel[i] = hrs.getMaxVelResp(Math.PI * 2 / t, z);
            ++i;
        }
        double[] si = NumericProcess.trapezium(rvel, step);
        return si[si.length - 1] / 2.4;
    }

    private void removeMean() {
        double[] n1 = new double[(int)(this.sr * 3.0)];
        System.arraycopy(this.iacc1, 0, n1, 0, n1.length);
        double m1 = ArrayMath.mean((double[])n1);
        this.iacc1 = ArrayMath.add((double[])this.iacc1, (double)(-m1));
        double[] n2 = new double[(int)(this.sr * 3.0)];
        System.arraycopy(this.iacc2, 0, n2, 0, n2.length);
        double m2 = ArrayMath.mean((double[])n2);
        this.iacc2 = ArrayMath.add((double[])this.iacc2, (double)(-m2));
    }

    private double peakAcc() {
        double[] a1 = new double[this.iacc1.length];
        System.arraycopy(this.iacc1, 0, a1, 0, a1.length);
        double p1 = this.peakAcc(a1, this.sr);
        double[] a2 = new double[this.iacc2.length];
        System.arraycopy(this.iacc2, 0, a2, 0, a2.length);
        double p2 = this.peakAcc(a2, this.sr);
        return (p1 + p2) / 2.0;
    }

    private double peakAcc(double[] a, double sr) {
        Numeric.linearFillGaps(a);
        Numeric.taper(a, a.length, (int)sr * 5);
        Filter[] bp = ButterFilter.getButterFilter(sr, 1, "BP", 8, 0.1, 10.0);
        a = Filter.filter(bp[0].getNumCoef(), bp[0].getDenCoef(), a);
        return ArrayMath.max((double[])a);
    }

    private double peakVel() {
        double[] a1 = new double[this.iacc1.length];
        System.arraycopy(this.iacc1, 0, a1, 0, a1.length);
        double p1 = this.peakVel(a1, this.sr);
        double[] a2 = new double[this.iacc2.length];
        System.arraycopy(this.iacc2, 0, a2, 0, a2.length);
        double p2 = this.peakVel(a2, this.sr);
        return (p1 + p2) / 2.0;
    }

    private double peakVel(double[] a, double sr) {
        Numeric.linearFillGaps(a);
        Numeric.taper(a, a.length, (int)sr * 5);
        Filter[] bp = ButterFilter.getButterFilter(sr, 1, "BP", 8, 0.05, sr / 2.0);
        a = Filter.filter(bp[0].getNumCoef(), bp[0].getDenCoef(), a);
        a = NumericProcess.trapezium(a, 1.0 / sr);
        Numeric.taper(a, a.length, (int)sr * 5);
        bp = ButterFilter.getButterFilter(sr, 1, "BP", 8, 0.1, 1.0);
        a = Filter.filter(bp[0].getNumCoef(), bp[0].getDenCoef(), a);
        return ArrayMath.max((double[])a);
    }

    public static void main(String[] args) {
        double sr = 50.0;
        double[] a1 = new double[5000];
        double[] a2 = new double[5000];
        double f = 5.0;
        int i = 0;
        while (i < a1.length) {
            a1[i] = 3.0 * Math.sin(6.2831852 * f * (double)i / sr) + 0.0;
            a2[i] = -5000.0;
            ++i;
        }
        MMIntensity mmi = new MMIntensity();
        mmi.setInputAcc(a1, a2, sr);
        int intensity = mmi.getMMI();
        System.out.println(intensity);
    }
}

