/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.seismograph;

import JSci.maths.ArrayMath;

public class HudsonResponseSpectrum {
    private double sr;
    private double[] iacc;
    private double[] rdis;
    private double[] rvel;
    private double[] racc;

    public void setInputAcc(double[] iacc, double sr) {
        this.iacc = iacc;
        this.sr = sr;
    }

    public double[] getRdis() {
        return this.rdis;
    }

    public double[] getRacc() {
        return this.racc;
    }

    public double[] getRvel() {
        return this.rvel;
    }

    public double getMaxVelResp(double w, double z) {
        this.process(w, z);
        return ArrayMath.max((double[])this.rvel);
    }

    public void process(double w, double z) {
        double dt = 1.0 / this.sr;
        this.rdis = new double[this.iacc.length];
        this.rvel = new double[this.iacc.length];
        this.racc = new double[this.iacc.length];
        double a11 = this.a11(w, z, dt);
        double a12 = this.a12(w, z, dt);
        double a21 = this.a21(w, z, dt);
        double a22 = this.a22(w, z, dt);
        double b11 = this.b11(w, z, dt);
        double b12 = this.b12(w, z, dt);
        double b21 = this.b21(w, z, dt);
        double b22 = this.b22(w, z, dt);
        int i = 0;
        while (i < this.iacc.length - 1) {
            this.rdis[i + 1] = a11 * this.rdis[i] + a12 * this.rvel[i] + b11 * this.iacc[i] + b12 * this.iacc[i + 1];
            this.rvel[i + 1] = a21 * this.rdis[i] + a22 * this.rvel[i] + b21 * this.iacc[i] + b22 * this.iacc[i + 1];
            this.racc[i + 1] = -this.iacc[i + 1] - 2.0 * z * w * this.rvel[i + 1] - w * w * this.rdis[i + 1];
            ++i;
        }
    }

    double a11(double w, double z, double dt) {
        double a = Math.sqrt(1.0 - z * z);
        double e = Math.exp(-z * w * dt);
        double s = Math.sin(w * a * dt);
        double c = Math.cos(w * a * dt);
        double c1 = z / a;
        return e * (c1 * s + c);
    }

    double a12(double w, double z, double dt) {
        double a = Math.sqrt(1.0 - z * z);
        double e = Math.exp(-z * w * dt);
        double s = Math.sin(w * a * dt);
        return e * s / w * a;
    }

    double a21(double w, double z, double dt) {
        double a = Math.sqrt(1.0 - z * z);
        double e = Math.exp(-z * w * dt);
        double s = Math.sin(w * a * dt);
        return -e * w * s / a;
    }

    double a22(double w, double z, double dt) {
        double a = Math.sqrt(1.0 - z * z);
        double e = Math.exp(-z * w * dt);
        double s = Math.sin(w * a * dt);
        double c = Math.cos(w * a * dt);
        double c1 = z / a;
        return e * (c - c1 * s);
    }

    double b11(double w, double z, double dt) {
        double a = Math.sqrt(1.0 - z * z);
        double e = Math.exp(-z * w * dt);
        double s = Math.sin(w * a * dt);
        double c = Math.cos(w * a * dt);
        double c1 = (2.0 * z * z - 1.0) / (w * w * dt) + z / w;
        double c2 = 2.0 * z / (w * w * w * dt) + 1.0 / w / w;
        double c3 = 2.0 * z / (w * w * w * dt);
        return e * (c1 * s / (w * a) + c2 * c) - c3;
    }

    double b12(double w, double z, double dt) {
        double a = Math.sqrt(1.0 - z * z);
        double e = Math.exp(-z * w * dt);
        double s = Math.sin(w * a * dt);
        double c = Math.cos(w * a * dt);
        double c1 = (2.0 * z * z - 1.0) / (w * w * dt);
        double c2 = 2.0 * z / (w * w * w * dt);
        return -e * (c1 * s / (w * a) + c2 * c) + c2 - 1.0 / w / w;
    }

    double b21(double w, double z, double dt) {
        double a = Math.sqrt(1.0 - z * z);
        double e = Math.exp(-z * w * dt);
        double s = Math.sin(w * a * dt);
        double c = Math.cos(w * a * dt);
        double c1 = (2.0 * z * z - 1.0) / (w * w * dt) + z / w;
        double c2 = 2.0 * z / (w * w * w * dt) + 1.0 / w / w;
        double c3 = 1.0 / (w * w * dt);
        return e * (c1 * (c - z / a * s) - c2 * (w * a * s + z * w * c)) + c3;
    }

    double b22(double w, double z, double dt) {
        double a = Math.sqrt(1.0 - z * z);
        double e = Math.exp(-z * w * dt);
        double s = Math.sin(w * a * dt);
        double c = Math.cos(w * a * dt);
        double c1 = 1.0 / (w * w * dt);
        double c2 = z / (w * w * a * dt);
        double c3 = 1.0 / (w * w * dt);
        return -e * (c1 * c + c2 * s) - c3;
    }
}

