/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.seismograph;

import cn.org.gddsn.seis.evtformat.sac.SAC;
import cn.org.gddsn.signal.cfft99.Fft991;
import cn.org.gddsn.signal.seismograph.PrepFFT;
import cn.org.gddsn.signal.seismograph.Transfer;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class GMAnalyzer {
    static Logger logger = Logger.getLogger(GMAnalyzer.class);

    private GMAnalyzer() {
    }

    public static int gma(double[] input, int npts, double deltat, Transfer.ResponseStruct origRS, double[] fTaper, double tTaper, int[] pPadLen, int[] pnfft, double[] spectPer, int nsp, double[] spectDamp, int nsd, double[] output, int outBufLen, double[] fAccR, double[] fAccI, double[] fIntR, double[] fIntI, double[] fPsaR, double[] fPsaI, double[] workFFT) {
        double acci;
        double accr;
        int ii;
        int nfft;
        int isp;
        Transfer.ResponseStruct accRS = new Transfer.ResponseStruct();
        Transfer.ResponseStruct psaRS = new Transfer.ResponseStruct();
        PrepFFT.FACT[] pfact = new PrepFFT.FACT[1];
        int retval = 0;
        int isd = 0;
        double[] acc = output;
        if (origRS == null || npts < 2 || deltat <= 0.0 || fTaper == null || outBufLen < npts) {
            return -3;
        }
        if (fTaper[0] > fTaper[1] || fTaper[1] >= fTaper[2] || fTaper[2] > fTaper[3] || origRS.dGain == 0.0) {
            return -3;
        }
        accRS.dGain = 1.0 / (1.0E7 * origRS.dGain);
        accRS.iNumPoles = origRS.iNumZeros;
        accRS.iNumZeros = origRS.iNumPoles + 2;
        accRS.Poles = new Transfer.PZNum[accRS.iNumPoles];
        int q = 0;
        while (q < accRS.iNumPoles) {
            accRS.Poles[q] = new Transfer.PZNum();
            ++q;
        }
        accRS.Zeros = new Transfer.PZNum[accRS.iNumZeros];
        q = 0;
        while (q < accRS.iNumZeros) {
            accRS.Zeros[q] = new Transfer.PZNum();
            ++q;
        }
        int nz = 0;
        int np = 0;
        int i = 0;
        while (i < origRS.iNumPoles) {
            accRS.Zeros[nz].dReal = origRS.Poles[i].dReal;
            accRS.Zeros[nz].dImag = origRS.Poles[i].dImag;
            ++nz;
            ++i;
        }
        i = 0;
        while (i < origRS.iNumZeros) {
            accRS.Poles[np].dReal = origRS.Zeros[i].dReal;
            accRS.Poles[np].dImag = origRS.Zeros[i].dImag;
            ++np;
            ++i;
        }
        i = 0;
        while (i < 2) {
            accRS.Zeros[nz].dReal = 0.0;
            accRS.Zeros[nz].dImag = 0.0;
            ++nz;
            ++i;
        }
        Transfer.pzCancel(accRS, 1.0E-5);
        if (pPadLen[0] < 0) {
            pPadLen[0] = Transfer.respLen(accRS, deltat, fTaper);
            if (pPadLen[0] < 0) {
                retval = pPadLen[0];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("\nrespLen error: %ld\n", pPadLen[0]));
                }
                Transfer.cleanPZ(accRS);
                Transfer.cleanPZ(psaRS);
                return retval;
            }
            double minDamp = spectDamp[0];
            isd = 1;
            while (isd < nsd) {
                if (minDamp > spectDamp[isd]) {
                    minDamp = spectDamp[isd];
                }
                ++isd;
            }
            double maxPeriod = spectPer[0];
            isp = 1;
            while (isp < nsp) {
                if (maxPeriod < spectPer[isp]) {
                    maxPeriod = spectPer[isp];
                }
                ++isp;
            }
            int psaPadLen = (int)(-1.0 * maxPeriod * Math.log(0.01) / (minDamp * 2.0 * Math.PI * deltat));
            if (pPadLen[0] < psaPadLen) {
                pPadLen[0] = psaPadLen;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("estimated pad length: %ld\n", pPadLen[0]));
            }
        }
        int trial_nfft = pPadLen[0] + npts;
        while ((nfft = PrepFFT.prepFFT(trial_nfft, pfact)) > outBufLen - 2) {
            if (nfft < 0) {
                retval = nfft;
                Transfer.cleanPZ(accRS);
                Transfer.cleanPZ(psaRS);
                return retval;
            }
            trial_nfft -= 100;
        }
        if (nfft - pPadLen[0] < npts) {
            npts = nfft - pPadLen[0];
        }
        int nfreq = nfft / 2;
        i = 0;
        while (i < npts) {
            acc[i] = input[i];
            ++i;
        }
        i = npts;
        while (i < nfft + 2) {
            acc[i] = 0.0;
            ++i;
        }
        int ntaper = (int)(tTaper / deltat);
        Transfer.taper(acc, npts, ntaper);
        Fft991.fft991(acc, 0, workFFT, 0, pfact[0].trigs, 0, pfact[0].ifax, 0, 1, nfft, nfft, 1, -1);
        Transfer.response(nfft, deltat, accRS, fAccR, fAccI);
        GMAnalyzer.makeInt(nfft, deltat, fIntI);
        acc[0] = 0.0;
        output[outBufLen + 0] = 0.0;
        output[outBufLen * 2 + 0] = 0.0;
        acc[1] = 0.0;
        output[outBufLen + 1] = 0.0;
        output[outBufLen * 2 + 1] = 0.0;
        double delfreq = 1.0 / ((double)nfft * deltat);
        i = 1;
        while (i < nfreq) {
            ii = i + i;
            double f = (double)i * delfreq;
            double tpr = Transfer.ftaper(f, fTaper[1], fTaper[0]) * Transfer.ftaper(f, fTaper[2], fTaper[3]);
            double dre = acc[ii];
            double dim = acc[ii + 1];
            accr = (dre * fAccR[i] - dim * fAccI[i]) * tpr;
            acci = (dre * fAccI[i] + dim * fAccR[i]) * tpr;
            acc[ii] = accr;
            acc[ii + 1] = acci;
            output[outBufLen + ii] = fIntI[i] * acci;
            output[outBufLen + ii + 1] = -fIntI[i] * accr;
            output[outBufLen * 2 + ii] = -fIntI[i] * output[outBufLen + ii + 1];
            output[outBufLen * 2 + ii + 1] = fIntI[i] * output[outBufLen + ii];
            ++i;
        }
        acc[nfft] = 0.0;
        output[outBufLen + nfft] = 0.0;
        output[outBufLen * 2 + nfft] = 0.0;
        int isdp = -1;
        isp = 0;
        while (isp < nsp) {
            isd = 0;
            while (isd < nsd) {
                ++isdp;
                retval = GMAnalyzer.makePsa(spectPer[isp], spectDamp[isd], psaRS);
                if (retval < 0) {
                    Transfer.cleanPZ(accRS);
                    Transfer.cleanPZ(psaRS);
                    return retval;
                }
                Transfer.response(nfft, deltat, psaRS, fPsaR, fPsaI);
                output[outBufLen * (3 + isdp) + 0] = 0.0;
                output[outBufLen * (3 + isdp) + 1] = 0.0;
                i = 1;
                while (i < nfreq) {
                    ii = i + i;
                    accr = acc[ii];
                    acci = acc[ii + 1];
                    output[outBufLen * (3 + isdp) + ii] = accr * fPsaR[i] - acci * fPsaI[i] + accr;
                    output[outBufLen * (3 + isdp) + ii + 1] = accr * fPsaI[i] + acci * fPsaR[i] + acci;
                    ++i;
                }
                output[outBufLen * (3 + isdp) + nfft] = 0.0;
                output[outBufLen * (3 + isdp) + nfft + 1] = 0.0;
                Transfer.cleanPZ(psaRS);
                ++isd;
            }
            ++isp;
        }
        Fft991.fft991(output, 0, workFFT, 0, pfact[0].trigs, 0, pfact[0].ifax, 0, 1, outBufLen, nfft, 3 + isd * isp, 1);
        pnfft[0] = nfft;
        Transfer.cleanPZ(accRS);
        Transfer.cleanPZ(psaRS);
        return retval;
    }

    private static void makeInt(int nfft, double deltat, double[] fIntI) {
        int ntr = nfft / 2;
        double delomg = Math.PI * 2 / ((double)nfft * deltat);
        fIntI[0] = 0.0;
        int i = 1;
        while (i < ntr) {
            double omega = delomg * (double)i;
            fIntI[i] = 1.0 / omega;
            ++i;
        }
    }

    private static int makePsa(double period, double damp, Transfer.ResponseStruct rs) {
        double omega = Math.PI * 2 / period;
        double mu = Math.sqrt(1.0 - damp * damp);
        rs.iNumZeros = 2;
        rs.iNumPoles = 2;
        rs.Zeros = new Transfer.PZNum[2];
        rs.Poles = new Transfer.PZNum[2];
        int i = 0;
        while (i < rs.iNumZeros) {
            rs.Zeros[i] = new Transfer.PZNum();
            ++i;
        }
        i = 0;
        while (i < rs.iNumPoles) {
            rs.Poles[i] = new Transfer.PZNum();
            ++i;
        }
        rs.Zeros[0].dImag = 0.0;
        rs.Zeros[0].dReal = 0.0;
        rs.Zeros[1].dImag = 0.0;
        rs.Zeros[1].dReal = 0.0;
        rs.dGain = -1.0;
        rs.Poles[0].dReal = -omega * damp;
        rs.Poles[0].dImag = omega * mu;
        rs.Poles[1].dReal = -omega * damp;
        rs.Poles[1].dImag = -omega * mu;
        return 0;
    }

    public static void main(String[] args) throws IOException {
        double[] spectPer = new double[]{0.3, 1.0, 3.0};
        double[] spectDamp = new double[]{0.05};
        int nsd = spectDamp.length;
        int nsp = spectPer.length;
        SAC sac = new SAC();
        sac.readBinarySAC(new File("/opt/workspace/RTS/TestCase/SimuSac/jpdata/noto/ISK003.KN.z.sac"));
        int lenRaw = sac.NPTS;
        double delta = sac.DELTA;
        double[] rawData = new double[lenRaw];
        int i = 0;
        while (i < lenRaw) {
            rawData[i] = sac.data1[i];
            ++i;
        }
        Transfer.ResponseStruct origRS = new Transfer.ResponseStruct();
        Transfer.readSacPZ("/tmp/GD.SHT.00.BHZ.pz", origRS);
        double tTaper = 0.0;
        double[] taperFreqs = new double[]{1.0, 1.0, 10.0, 10.0};
        taperFreqs[0] = 0.05;
        taperFreqs[1] = 0.1;
        taperFreqs[2] = 0.45 / delta;
        taperFreqs[3] = 0.5 / delta;
        PrepFFT.FACT[] pf = new PrepFFT.FACT[1];
        int nfft = PrepFFT.prepFFT(lenRaw, pf);
        int numProc = 3 + nsd * nsp;
        int lenProc = nfft + 2;
        double[] procData = new double[numProc * lenProc];
        double[] fAccR = new double[lenProc / 2];
        double[] fAccI = new double[lenProc / 2];
        double[] fIntR = new double[lenProc / 2];
        double[] fIntI = new double[lenProc / 2];
        double[] fPsaR = new double[lenProc / 2];
        double[] fPsaI = new double[lenProc / 2];
        double[] workFFT = new double[numProc * lenProc];
        int[] rpadLen = new int[1];
        int[] rnfft = new int[1];
        int rc = GMAnalyzer.gma(rawData, lenRaw, delta, origRS, taperFreqs, tTaper, rpadLen, rnfft, spectPer, nsp, spectDamp, nsd, procData, lenProc, fAccR, fAccI, fIntR, fIntI, fPsaR, fPsaI, workFFT);
        System.out.println(rc);
    }
}

