/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter.design;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

class PoleZeroPlot
extends Canvas {
    private static final long serialVersionUID = 1L;
    double[] pReal;
    double[] pImag;
    double[] z;
    int order = 0;
    int gridIntervals = 10;
    int zSize = 4;
    int pSize = 3;
    double scale;
    Color plotColor = Color.blue;
    Color axisColor = Color.darkGray;
    Color circColor = Color.red;
    Color gridColor = Color.darkGray;
    Color bgColor = Color.lightGray;
    int vertSpace = 20;
    int horzSpace = 20;

    public void setPlotColor(Color c) {
        if (c != null) {
            this.plotColor = c;
        }
    }

    public Color getPlotColor() {
        return this.plotColor;
    }

    public void setAxisColor(Color c) {
        if (c != null) {
            this.axisColor = c;
        }
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setGridColor(Color c) {
        if (c != null) {
            this.gridColor = c;
        }
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setCircColor(Color c) {
        if (c != null) {
            this.circColor = c;
        }
    }

    public Color getCircColor() {
        return this.circColor;
    }

    public void setBgColor(Color c) {
        if (c != null) {
            this.bgColor = c;
        }
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setPolesAndZeros(double[] pr, double[] pi, double[] zr) {
        this.order = pr.length - 1;
        this.pReal = new double[this.order + 1];
        this.pImag = new double[this.order + 1];
        this.z = new double[this.order + 1];
        int i = 1;
        while (i <= this.order) {
            this.pReal[i] = pr[i];
            this.pImag[i] = pi[i];
            this.z[i] = zr[i];
            ++i;
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        int y;
        int x;
        int xc = this.getSize().width / 2;
        int yc = this.getSize().height / 2;
        int width = this.getSize().width - 2 * this.horzSpace;
        int height = this.getSize().height - 2 * this.vertSpace;
        int radius = Math.min(width / 2, height / 2);
        int top = yc - radius;
        int bottom = yc + radius;
        int left = xc - radius;
        int right = xc + radius;
        this.scale = (double)(2 * radius) / (double)this.gridIntervals;
        this.setBackground(this.bgColor);
        g.setColor(this.gridColor);
        int i = 0;
        while (i <= this.gridIntervals) {
            x = left + (int)Math.round((double)i * this.scale);
            y = top + (int)Math.round((double)i * this.scale);
            g.drawLine(x, top, x, bottom);
            g.drawLine(left, y, right, y);
            ++i;
        }
        g.setColor(this.axisColor);
        g.drawLine(xc, top - this.vertSpace, xc, bottom + this.vertSpace);
        g.setFont(new Font("Sans serif", 1, 10));
        FontMetrics fm = g.getFontMetrics();
        int h = fm.getMaxAscent();
        g.drawString("Im", xc + 4, top - this.vertSpace + h);
        g.drawLine(left - this.horzSpace, yc, right + this.horzSpace, yc);
        int w = fm.stringWidth("Re");
        g.drawString("Re", right + this.horzSpace - w, yc + h + 4);
        g.setColor(this.circColor);
        g.drawOval(left, top, 2 * radius, 2 * radius);
        if (this.order > 0) {
            g.setColor(this.plotColor);
            int i2 = 1;
            while (i2 <= this.order) {
                x = xc + (int)Math.round((double)radius * this.z[i2]);
                g.drawOval(x - this.zSize, yc - this.zSize, 2 * this.zSize, 2 * this.zSize);
                ++i2;
            }
            i2 = 1;
            while (i2 <= this.order) {
                x = xc + (int)Math.round((double)radius * this.pReal[i2]);
                y = yc - (int)Math.round((double)radius * this.pImag[i2]);
                g.drawLine(x - this.pSize, y - this.pSize, x + this.pSize, y + this.pSize);
                g.drawLine(x - this.pSize, y + this.pSize, x + this.pSize, y - this.pSize);
                ++i2;
            }
        }
    }
}

