/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter.design;

import cn.org.gddsn.signal.filter.design.FIRFilter;
import cn.org.gddsn.signal.filter.design.FIRFilterDesign_btnCoeffs_actionAdapter;
import cn.org.gddsn.signal.filter.design.FIRFilterDesign_btnDesign_actionAdapter;
import cn.org.gddsn.signal.filter.design.FIRFilterDesign_btnResponse_actionAdapter;
import cn.org.gddsn.signal.filter.design.FIRFilterDesign_cbBandPass_itemAdapter;
import cn.org.gddsn.signal.filter.design.FIRFilterDesign_cbHighPass_itemAdapter;
import cn.org.gddsn.signal.filter.design.FIRFilterDesign_cbLowPass_itemAdapter;
import cn.org.gddsn.signal.filter.design.FIRFilterDesign_chMinGain_itemAdapter;
import cn.org.gddsn.signal.filter.design.FIRFilterDesign_chWindowType_itemAdapter;
import cn.org.gddsn.signal.filter.design.FIRFilterDesign_tfFreq1_textAdapter;
import cn.org.gddsn.signal.filter.design.FIRFilterDesign_tfFreq2_textAdapter;
import cn.org.gddsn.signal.filter.design.FIRFilterDesign_tfOrder_textAdapter;
import cn.org.gddsn.signal.filter.design.GraphPlot;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;

public class FIRFilterDesign
extends Applet {
    private static final long serialVersionUID = 1L;
    static double rate = 100.0;
    static int freqPoints = 250;
    int order;
    double[] gain = new double[freqPoints + 1];
    String windowType;
    String filterType;
    GraphPlot frPlot = new GraphPlot();
    FIRFilter filter = new FIRFilter();
    Panel pnlDisplay = new Panel();
    Panel pnlControls = new Panel();
    CardLayout cardLayout1 = new CardLayout();
    Panel pnlFRPlot = new Panel();
    Panel pnlLeftPanel = new Panel();
    Panel pnlWindowType = new Panel();
    Panel pnlOrder = new Panel();
    Panel pnlButtons = new Panel();
    Panel pnlRightPanel = new Panel();
    Panel pnlPassband = new Panel();
    Panel pnlAtten = new Panel();
    Panel pnlTrBand = new Panel();
    Choice chWindowType = new Choice();
    CheckboxGroup cbgFilterType = new CheckboxGroup();
    Checkbox cbLowPass = new Checkbox();
    Checkbox cbBandPass = new Checkbox();
    Checkbox cbHighPass = new Checkbox();
    TextField tfFreq1 = new TextField();
    TextField tfFreq2 = new TextField();
    Label lblAttenValue = new Label();
    Label lblTrBandValue = new Label();
    TextField tfOrder = new TextField();
    Label lblOrder = new Label();
    Label lblPassband = new Label();
    Label lblTo = new Label();
    Label lblPassbandUnit = new Label();
    Label lbldB = new Label();
    Label lblAtten = new Label();
    Label lblTrBand = new Label();
    Label lblTrBandUnit = new Label();
    Button btnDesign = new Button();
    Button btnResponse = new Button();
    GridLayout gridLayout1 = new GridLayout();
    GridLayout gridLayout2 = new GridLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    FlowLayout flowLayout3 = new FlowLayout();
    GridLayout gridLayout3 = new GridLayout();
    FlowLayout flowLayout4 = new FlowLayout();
    FlowLayout flowLayout5 = new FlowLayout();
    FlowLayout flowLayout6 = new FlowLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    Label lblWindowType = new Label();
    Panel pnlFilterType = new Panel();
    FlowLayout flowLayout7 = new FlowLayout();
    Label lblFilterType = new Label();
    Panel pnlMinGain = new Panel();
    FlowLayout flowLayout8 = new FlowLayout();
    Label lblMinGain = new Label();
    Choice chMinGain = new Choice();
    Label lblMinGainUnit = new Label();
    BorderLayout borderLayout2 = new BorderLayout();
    Panel pnlCoeffs = new Panel();
    BorderLayout borderLayout3 = new BorderLayout();
    TextArea txtCoeffs = new TextArea();
    Button btnCoeffs = new Button();

    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() throws Exception {
        this.setSize(new Dimension(600, 400));
        this.chWindowType.addItemListener(new FIRFilterDesign_chWindowType_itemAdapter(this));
        this.setLayout(this.borderLayout1);
        this.pnlTrBand.setLayout(this.flowLayout6);
        this.pnlAtten.setLayout(this.flowLayout5);
        this.pnlPassband.setLayout(this.flowLayout4);
        this.pnlRightPanel.setLayout(this.gridLayout3);
        this.pnlWindowType.setLayout(this.flowLayout3);
        this.pnlButtons.setLayout(this.flowLayout2);
        this.pnlOrder.setLayout(this.flowLayout1);
        this.pnlLeftPanel.setLayout(this.gridLayout2);
        this.pnlControls.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.gridLayout2.setRows(4);
        this.gridLayout2.setColumns(1);
        this.flowLayout1.setHgap(10);
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setVgap(10);
        this.flowLayout2.setHgap(10);
        this.flowLayout2.setAlignment(0);
        this.flowLayout2.setVgap(10);
        this.flowLayout3.setHgap(10);
        this.flowLayout3.setAlignment(0);
        this.flowLayout3.setVgap(10);
        this.gridLayout3.setRows(4);
        this.gridLayout3.setColumns(1);
        this.flowLayout4.setHgap(10);
        this.flowLayout4.setAlignment(0);
        this.flowLayout4.setVgap(10);
        this.flowLayout5.setHgap(10);
        this.flowLayout5.setAlignment(0);
        this.flowLayout5.setVgap(10);
        this.flowLayout6.setHgap(10);
        this.flowLayout6.setAlignment(0);
        this.flowLayout6.setVgap(10);
        this.lblWindowType.setText("Window type:");
        this.flowLayout7.setHgap(10);
        this.flowLayout7.setAlignment(0);
        this.flowLayout7.setVgap(10);
        this.lblFilterType.setText("Filter type:");
        this.flowLayout8.setHgap(10);
        this.flowLayout8.setAlignment(0);
        this.flowLayout8.setVgap(10);
        this.lblMinGain.setText("Minimum plot gain:");
        this.chMinGain.addItem("-10");
        this.chMinGain.addItem("-50");
        this.chMinGain.addItem("-100");
        this.chMinGain.addItem("-200");
        this.chMinGain.select("-100");
        this.chMinGain.addItemListener(new FIRFilterDesign_chMinGain_itemAdapter(this));
        this.lblMinGainUnit.setText("dB");
        this.txtCoeffs.setText("Filter coefficients\n\n");
        this.btnCoeffs.setEnabled(false);
        this.btnCoeffs.setLabel("Coefficients");
        this.btnCoeffs.addActionListener(new FIRFilterDesign_btnCoeffs_actionAdapter(this));
        this.pnlCoeffs.setLayout(this.borderLayout3);
        this.pnlMinGain.setLayout(this.flowLayout8);
        this.pnlFilterType.setLayout(this.flowLayout7);
        this.frPlot.setPlotStyle(2);
        this.frPlot.setTracePlot(true);
        this.frPlot.setLogScale(true);
        this.pnlFRPlot.setLayout(this.borderLayout2);
        this.frPlot.setBgColor(Color.lightGray);
        this.frPlot.setPlotColor(Color.blue);
        this.frPlot.setAxisColor(Color.darkGray);
        this.frPlot.setGridColor(Color.darkGray);
        this.pnlDisplay.setLayout(this.cardLayout1);
        this.add((Component)this.pnlDisplay, "Center");
        this.pnlDisplay.add((Component)this.pnlFRPlot, "FRPlot");
        this.pnlFRPlot.add((Component)this.frPlot, "Center");
        this.pnlDisplay.add((Component)this.pnlCoeffs, "Coeffs");
        this.pnlCoeffs.add((Component)this.txtCoeffs, "Center");
        this.add((Component)this.pnlControls, "South");
        this.pnlControls.add(this.pnlLeftPanel);
        this.pnlLeftPanel.add(this.pnlFilterType);
        this.pnlFilterType.add(this.lblFilterType);
        this.pnlFilterType.add(this.cbLowPass);
        this.pnlFilterType.add(this.cbBandPass);
        this.pnlFilterType.add(this.cbHighPass);
        this.pnlLeftPanel.add(this.pnlWindowType);
        this.pnlWindowType.add(this.lblWindowType);
        this.pnlWindowType.add(this.chWindowType);
        this.pnlLeftPanel.add(this.pnlOrder);
        this.pnlLeftPanel.add(this.pnlPassband);
        this.pnlOrder.add(this.lblOrder);
        this.pnlOrder.add(this.tfOrder);
        this.pnlControls.add(this.pnlRightPanel);
        this.pnlRightPanel.add(this.pnlAtten);
        this.pnlAtten.add(this.lblAtten);
        this.pnlAtten.add(this.lblAttenValue);
        this.pnlAtten.add(this.lbldB);
        this.pnlPassband.add(this.lblPassband);
        this.pnlPassband.add(this.tfFreq1);
        this.pnlPassband.add(this.lblTo);
        this.pnlPassband.add(this.tfFreq2);
        this.pnlPassband.add(this.lblPassbandUnit);
        this.pnlRightPanel.add(this.pnlTrBand);
        this.pnlTrBand.add(this.lblTrBand);
        this.pnlTrBand.add(this.lblTrBandValue);
        this.chWindowType.addItem("Rectangular");
        this.chWindowType.addItem("Hanning");
        this.chWindowType.addItem("Hamming");
        this.chWindowType.addItem("Blackman");
        this.cbLowPass.setLabel("LP");
        this.cbLowPass.setCheckboxGroup(this.cbgFilterType);
        this.cbLowPass.addItemListener(new FIRFilterDesign_cbLowPass_itemAdapter(this));
        this.cbBandPass.setLabel("BP");
        this.cbBandPass.setCheckboxGroup(this.cbgFilterType);
        this.cbBandPass.addItemListener(new FIRFilterDesign_cbBandPass_itemAdapter(this));
        this.cbHighPass.setLabel("HP");
        this.cbHighPass.setCheckboxGroup(this.cbgFilterType);
        this.cbHighPass.addItemListener(new FIRFilterDesign_cbHighPass_itemAdapter(this));
        this.cbLowPass.setState(true);
        this.tfOrder.setColumns(4);
        this.tfOrder.addTextListener(new FIRFilterDesign_tfOrder_textAdapter(this));
        this.lblOrder.setText("Filter order (even):");
        this.tfOrder.setText("20");
        this.btnDesign.setLabel("Design");
        this.btnDesign.addActionListener(new FIRFilterDesign_btnDesign_actionAdapter(this));
        this.btnResponse.setLabel("Frequency response");
        this.btnResponse.addActionListener(new FIRFilterDesign_btnResponse_actionAdapter(this));
        this.btnResponse.setEnabled(false);
        this.lblPassband.setText("Passband:");
        this.tfFreq1.setColumns(5);
        this.tfFreq1.addTextListener(new FIRFilterDesign_tfFreq1_textAdapter(this));
        this.tfFreq1.setText("0");
        this.tfFreq1.setEditable(false);
        this.lblTo.setAlignment(1);
        this.lblTo.setText("to");
        this.tfFreq2.setText("1000");
        this.tfFreq2.setColumns(5);
        this.tfFreq2.addTextListener(new FIRFilterDesign_tfFreq2_textAdapter(this));
        this.tfFreq2.setEditable(true);
        this.lblPassbandUnit.setText("Hz");
        this.lblAtten.setText("Stopband attenuation:");
        this.lblAttenValue.setText("    ");
        this.lbldB.setText("dB");
        this.lblTrBand.setText("Transition bandwidth:");
        this.lblTrBandValue.setText("     ");
        this.lblTrBandUnit.setText("Hz");
        this.pnlTrBand.add(this.lblTrBandUnit);
        this.pnlRightPanel.add((Component)this.pnlMinGain, null);
        this.pnlMinGain.add((Component)this.lblMinGain, null);
        this.pnlMinGain.add((Component)this.chMinGain, null);
        this.pnlMinGain.add((Component)this.lblMinGainUnit, null);
        this.pnlRightPanel.add(this.pnlButtons);
        this.pnlButtons.add(this.btnDesign);
        this.pnlButtons.add(this.btnResponse);
        this.pnlButtons.add((Component)this.btnCoeffs, null);
    }

    void designFilter() {
        this.windowType = this.chWindowType.getSelectedItem();
        this.filter.setWindowType(this.windowType);
        this.filterType = this.cbgFilterType.getSelectedCheckbox().getLabel();
        this.filter.setFilterType(this.filterType);
        this.filter.setRate(rate);
        this.order = Integer.parseInt(this.tfOrder.getText());
        if (this.order % 2 != 0) {
            ++this.order;
            this.tfOrder.setText(String.valueOf(this.order));
        }
        this.filter.setOrder(this.order);
        this.filter.setFreq1(Float.valueOf(this.tfFreq1.getText()).floatValue());
        this.filter.setFreq2(Float.valueOf(this.tfFreq2.getText()).floatValue());
        this.lblAttenValue.setText(String.valueOf(Math.round(this.filter.atten())));
        this.lblTrBandValue.setText(String.valueOf(Math.round(this.filter.trBand())));
        this.filter.design();
        this.btnResponse.setEnabled(true);
    }

    void plotResponse() {
        this.filter.setFreqPoints(freqPoints);
        this.gain = this.filter.filterGain();
        this.frPlot.setYmax(this.minPlotGain());
        this.frPlot.setPlotValues(this.gain);
        this.repaint();
    }

    void listCoeffs() {
        this.txtCoeffs.setText(String.valueOf(this.windowType) + " window FIR filter\n\n");
        this.txtCoeffs.append("Filter type: " + this.filterType + "\n");
        this.txtCoeffs.append("Passband: " + this.tfFreq1.getText() + " - " + this.tfFreq2.getText() + " Hz\n");
        this.txtCoeffs.append("Order: " + String.valueOf(this.order) + "\n");
        this.txtCoeffs.append("Transition band: " + this.lblTrBandValue.getText() + " Hz\n");
        this.txtCoeffs.append("Stopband attenuation: " + this.lblAttenValue.getText() + " dB\n\n");
        this.txtCoeffs.append("Coefficients:\n\n");
        int i = 0;
        while (i <= this.order) {
            this.txtCoeffs.append("a[" + String.valueOf(i) + "] =\t" + String.valueOf(this.filter.getCoeff(i)) + "\n");
            ++i;
        }
        this.cardLayout1.show(this.pnlDisplay, "Coeffs");
    }

    void cbLowPass_itemStateChanged(ItemEvent e) {
        if (this.cbLowPass.getState()) {
            this.tfFreq1.setText("0");
            this.tfFreq2.setText("");
            this.tfFreq1.setEditable(false);
            this.tfFreq2.setEditable(true);
            this.btnResponse.setEnabled(false);
        }
    }

    void cbBandPass_itemStateChanged(ItemEvent e) {
        if (this.cbBandPass.getState()) {
            this.tfFreq1.setText("");
            this.tfFreq2.setText("");
            this.tfFreq1.setEditable(true);
            this.tfFreq2.setEditable(true);
            this.btnResponse.setEnabled(false);
            this.btnCoeffs.setEnabled(false);
        }
    }

    void cbHighPass_itemStateChanged(ItemEvent e) {
        if (this.cbHighPass.getState()) {
            this.tfFreq1.setText("");
            this.tfFreq2.setText("4000");
            this.tfFreq1.setEditable(true);
            this.tfFreq2.setEditable(false);
            this.btnResponse.setEnabled(false);
            this.btnCoeffs.setEnabled(false);
        }
    }

    void btnDesign_actionPerformed(ActionEvent e) {
        this.designFilter();
    }

    void btnResponse_actionPerformed(ActionEvent e) {
        this.plotResponse();
        this.cardLayout1.show(this.pnlDisplay, "FRPlot");
        this.btnCoeffs.setEnabled(true);
    }

    void btnCoeffs_actionPerformed(ActionEvent e) {
        this.listCoeffs();
    }

    public String getAppletInfo() {
        return "(C) 1998 Dr Iain A Robin";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    private double minPlotGain() {
        return Math.abs(Float.valueOf(this.chMinGain.getSelectedItem()).floatValue());
    }

    void chMinGain_itemStateChanged(ItemEvent e) {
        if (this.btnResponse.isEnabled()) {
            this.plotResponse();
        }
    }

    void chWindowType_itemStateChanged(ItemEvent e) {
        this.btnResponse.setEnabled(false);
        this.btnCoeffs.setEnabled(false);
    }

    void tfOrder_textValueChanged(TextEvent e) {
        this.btnResponse.setEnabled(false);
        this.btnCoeffs.setEnabled(false);
    }

    void tfFreq1_textValueChanged(TextEvent e) {
        this.btnResponse.setEnabled(false);
        this.btnCoeffs.setEnabled(false);
    }

    void tfFreq2_textValueChanged(TextEvent e) {
        this.btnResponse.setEnabled(false);
        this.btnCoeffs.setEnabled(false);
    }
}

