/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.Complex;
import cn.org.gddsn.signal.filter.Filter;

class DirectFilter
extends Filter {
    double[] aList = new double[]{1.0};
    double[] bList = null;
    int[] nList = new int[1];
    Complex czn;
    Complex top;
    Complex bottom;

    DirectFilter() {
    }

    int getLength() {
        return this.aList.length;
    }

    boolean useConvolve() {
        return this.bList == null && this.aList.length > 25;
    }

    void dump() {
        System.out.print("a ");
        this.dump(this.aList);
        if (this.bList != null) {
            System.out.print("b ");
            this.dump(this.bList);
        }
    }

    void dump(double[] x) {
        int i = 0;
        while (i != x.length) {
            System.out.print(String.valueOf(x[i]) + " ");
            ++i;
        }
        System.out.println("");
    }

    void evalTransfer(Complex c) {
        if (this.czn == null) {
            this.czn = new Complex();
            this.top = new Complex();
            this.bottom = new Complex();
        }
        this.czn.set(1.0);
        this.top.set(0.0);
        this.bottom.set(0.0);
        int n = 0;
        int i = 0;
        while (i != this.aList.length) {
            int n1 = this.nList[i];
            while (n < n1) {
                if (n + 3 < n1) {
                    this.czn.set(c);
                    this.czn.pow(-n1);
                    n = n1;
                    break;
                }
                this.czn.div(c);
                ++n;
            }
            this.top.addMult(this.aList[i], this.czn);
            if (this.bList != null) {
                this.bottom.addMult(this.bList[i], this.czn);
            }
            ++i;
        }
        if (this.bList != null) {
            this.top.div(this.bottom);
        }
        c.set(this.top);
    }

    void run(double[] inBuf, double[] outBuf, int bp, int mask, int count, double[] state) {
        int fi2 = bp;
        double q = 0.0;
        int i2 = 0;
        while (i2 != count) {
            int ji;
            int j;
            fi2 = bp + i2;
            int i20 = fi2 & mask;
            q = inBuf[i20] * this.aList[0];
            if (this.bList == null) {
                j = 1;
                while (j < this.aList.length) {
                    ji = fi2 - this.nList[j] & mask;
                    q += inBuf[ji] * this.aList[j];
                    ++j;
                }
            } else {
                j = 1;
                while (j < this.aList.length) {
                    ji = fi2 - this.nList[j] & mask;
                    q += inBuf[ji] * this.aList[j] - outBuf[ji] * this.bList[j];
                    ++j;
                }
            }
            outBuf[i20] = q;
            ++i2;
        }
    }

    boolean isSimpleAList() {
        if (this.bList != null) {
            return false;
        }
        return this.nList[this.nList.length - 1] == this.nList.length - 1;
    }

    int getImpulseOffset() {
        if (this.isSimpleAList()) {
            return 0;
        }
        return this.getStepOffset();
    }

    int getStepOffset() {
        int offset = 0;
        int i = 0;
        while (i != this.aList.length) {
            if (this.nList[i] > offset) {
                offset = this.nList[i];
            }
            ++i;
        }
        return offset;
    }

    double[] getImpulseResponse(int offset) {
        if (this.isSimpleAList()) {
            return this.aList;
        }
        return super.getImpulseResponse(offset);
    }

    int getImpulseLen(int offset, double[] buf) {
        if (this.isSimpleAList()) {
            return this.aList.length;
        }
        return this.countPoints(buf, offset);
    }
}

