/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class TFR1 {
    static Logger logger = Logger.getLogger(TFR1.class);
    int[] maxrad = new int[1024];
    double[] xr = new double[1024];
    double[] xi = new double[1024];
    double[] rectafr = null;
    double[] rectafi = null;
    double[] rectafm2 = null;
    double[] polafm2 = null;
    double[] rectrotr = null;
    double[] rectroti = null;
    double[] req = null;
    double[] pheq = null;
    double[] plag = null;
    double[] ptheta = null;
    double[] rarN = null;
    double[] raiN = null;
    double[] sigma = new double[1024];
    double[] rar = new double[1024];
    double[] rai = new double[1024];
    double[] tfslicer = new double[1024];
    double[] tfslicei = new double[1024];
    int m_nraf;
    int m_nlag;
    int m_mfft;
    int m_nrad;
    int m_nphi;
    int m_nits;
    int m_slen;
    int m_fstep;
    double m_pi;
    double m_rtemp;
    double m_rtemp1;
    double m_rtemp2;
    double m_mu;
    double m_forget;
    double m_outdelay;
    int tlag;
    int fftlen;
    int tstep;
    double vol;

    public void init(int o_tlag, int o_fftlen, int o_tstep, double o_vol) {
        this.tlag = o_tlag;
        this.fftlen = o_fftlen;
        this.tstep = o_tstep;
        this.vol = o_vol;
        int num = (this.tlag + 1) * (this.tlag + 1);
        this.rectafr = new double[num];
        this.rectafi = new double[num];
        this.rectafm2 = new double[num];
        this.polafm2 = new double[num];
        this.rectrotr = new double[num];
        this.rectroti = new double[num];
        this.req = new double[num];
        this.pheq = new double[num];
        this.plag = new double[num];
        this.ptheta = new double[num];
        this.rarN = new double[num];
        this.raiN = new double[num];
        if (this.fftlen < 2 * this.tlag) {
            this.m_fstep = 2 * this.tlag / this.fftlen;
            this.fftlen = 2 * this.tlag;
        } else {
            this.m_fstep = 1;
        }
        this.m_nits = (int)(Math.log((double)this.tstep + 2.0) / Math.log(2.0));
        this.m_mu = 0.5;
        this.m_forget = 0.001;
        this.m_nraf = this.tlag;
        this.m_nrad = this.tlag;
        this.m_nphi = this.tlag;
        this.m_outdelay = this.tlag / 2;
        this.m_nlag = this.tlag + 1;
        this.m_mfft = TFR1.po2(this.fftlen);
        this.m_slen = (int)(1.42 * (double)(this.m_nlag - 1) + (double)this.m_nraf + 3.0);
        this.m_pi = 3.141592654;
        this.vol = 2.0 * this.vol * (double)this.m_nphi * (double)this.m_nrad * (double)this.m_nrad / (this.m_pi * (double)this.tlag);
        TFR1.kfill(this.m_nrad * this.m_nphi, 0.0, this.polafm2);
        TFR1.kfill(this.m_nraf * this.m_nlag, 0.0, this.rectafr);
        TFR1.kfill(this.m_nraf * this.m_nlag, 0.0, this.rectafi);
        TFR1.kfill(this.m_slen, 0.0, this.xr);
        TFR1.kfill(this.m_slen, 0.0, this.xi);
        TFR1.kfill(this.m_nphi, 1.0, this.sigma);
        TFR1.rectamake(this.m_nlag, this.m_nraf, this.m_forget, this.rar, this.rai, this.rarN, this.raiN);
        TFR1.plagmake(this.m_nrad, this.m_nphi, this.m_nlag, this.plag);
        TFR1.pthetamake(this.m_nrad, this.m_nphi, this.m_nraf, this.ptheta, this.maxrad);
        TFR1.rectrotmake(this.m_nraf, this.m_nlag, this.m_outdelay, this.rectrotr, this.rectroti);
        TFR1.rectopol(this.m_nraf, this.m_nlag, this.m_nrad, this.m_nphi, this.req, this.pheq);
    }

    public double[][] aok(double[][] signal, int s_strt, int xlen, double[][] tfr, boolean bFinish) {
        int m_tlen = bFinish ? xlen + s_strt + this.m_nraf + 2 : xlen + s_strt;
        int outct = 0;
        int ii = s_strt;
        while (ii < m_tlen) {
            TFR1.cshift(this.m_slen, this.xr);
            TFR1.cshift(this.m_slen, this.xi);
            if (ii < xlen + s_strt) {
                this.xr[0] = signal[0][ii];
                this.xi[0] = signal[1][ii];
            } else {
                this.xr[0] = 0.0;
                this.xi[0] = 0.0;
            }
            TFR1.rectaf(this.xr, this.xi, this.m_nlag, this.m_nraf, this.rar, this.rai, this.rarN, this.raiN, this.rectafr, this.rectafi);
            if (ii - ii / this.tstep * this.tstep == 0) {
                int j;
                TFR1.mkmag2(this.m_nlag * this.m_nraf, this.rectafr, this.rectafi, this.rectafm2);
                TFR1.polafint(this.m_nrad, this.m_nphi, this.m_nraf, this.maxrad, this.m_nlag, this.plag, this.ptheta, this.rectafm2, this.polafm2);
                TFR1.sigupdate(this.m_nrad, this.m_nphi, this.m_nits, this.vol, this.m_mu, this.maxrad, this.polafm2, this.sigma);
                int i = 0;
                while (i < this.m_nlag - 1) {
                    this.tfslicer[i] = 0.0;
                    this.tfslicei[i] = 0.0;
                    j = 0;
                    while (j < this.m_nraf) {
                        this.m_rtemp = TFR1.ccmr(this.rectafr[i * this.m_nraf + j], this.rectafi[i * this.m_nraf + j], this.rectrotr[i * this.m_nraf + j], this.rectroti[i * this.m_nraf + j]);
                        this.m_rtemp1 = TFR1.ccmi(this.rectafr[i * this.m_nraf + j], this.rectafi[i * this.m_nraf + j], this.rectrotr[i * this.m_nraf + j], this.rectroti[i * this.m_nraf + j]);
                        this.m_rtemp2 = TFR1.rectkern(i, j, this.m_nraf, this.m_nphi, this.req, this.pheq, this.sigma);
                        this.tfslicer[i] = this.tfslicer[i] + this.m_rtemp * this.m_rtemp2;
                        this.tfslicei[i] = this.tfslicei[i] + this.m_rtemp1 * this.m_rtemp2;
                        ++j;
                    }
                    ++i;
                }
                i = this.m_nlag - 1;
                while (i < this.fftlen - this.m_nlag + 2) {
                    this.tfslicer[i] = 0.0;
                    this.tfslicei[i] = 0.0;
                    ++i;
                }
                i = this.fftlen - this.m_nlag + 2;
                while (i < this.fftlen) {
                    this.tfslicer[i] = this.tfslicer[this.fftlen - i];
                    this.tfslicei[i] = -this.tfslicei[this.fftlen - i];
                    ++i;
                }
                TFR1.fft(this.fftlen, this.m_mfft, this.tfslicer, this.tfslicei);
                int itemp = this.fftlen / 2 + this.m_fstep;
                j = 0;
                i = itemp;
                while (i < this.fftlen) {
                    tfr[outct][j] = this.tfslicer[i];
                    ++j;
                    i += this.m_fstep;
                }
                i = 0;
                while (i < itemp) {
                    tfr[outct][j] = this.tfslicer[i];
                    ++j;
                    i += this.m_fstep;
                }
                ++outct;
            }
            ++ii;
        }
        return tfr;
    }

    public double[][] aok(double[][] signal, int s_strt, int xlen, double[][] tfr) {
        int m_start = s_strt + this.tlag / 2;
        int m_tlen = s_strt + this.tlag / 2 + xlen;
        int outct = 0;
        int ii = 0;
        while (ii < m_tlen) {
            TFR1.cshift(this.m_slen, this.xr);
            TFR1.cshift(this.m_slen, this.xi);
            this.xr[0] = signal[0][ii];
            this.xi[0] = signal[1][ii];
            TFR1.rectaf(this.xr, this.xi, this.m_nlag, this.m_nraf, this.rar, this.rai, this.rarN, this.raiN, this.rectafr, this.rectafi);
            int ic = ii - m_start;
            if (ic >= 0 && ic - ic / this.tstep * this.tstep == 0) {
                int j;
                TFR1.mkmag2(this.m_nlag * this.m_nraf, this.rectafr, this.rectafi, this.rectafm2);
                TFR1.polafint(this.m_nrad, this.m_nphi, this.m_nraf, this.maxrad, this.m_nlag, this.plag, this.ptheta, this.rectafm2, this.polafm2);
                TFR1.sigupdate(this.m_nrad, this.m_nphi, this.m_nits, this.vol, this.m_mu, this.maxrad, this.polafm2, this.sigma);
                int i = 0;
                while (i < this.m_nlag - 1) {
                    this.tfslicer[i] = 0.0;
                    this.tfslicei[i] = 0.0;
                    j = 0;
                    while (j < this.m_nraf) {
                        this.m_rtemp = TFR1.ccmr(this.rectafr[i * this.m_nraf + j], this.rectafi[i * this.m_nraf + j], this.rectrotr[i * this.m_nraf + j], this.rectroti[i * this.m_nraf + j]);
                        this.m_rtemp1 = TFR1.ccmi(this.rectafr[i * this.m_nraf + j], this.rectafi[i * this.m_nraf + j], this.rectrotr[i * this.m_nraf + j], this.rectroti[i * this.m_nraf + j]);
                        this.m_rtemp2 = TFR1.rectkern(i, j, this.m_nraf, this.m_nphi, this.req, this.pheq, this.sigma);
                        this.tfslicer[i] = this.tfslicer[i] + this.m_rtemp * this.m_rtemp2;
                        this.tfslicei[i] = this.tfslicei[i] + this.m_rtemp1 * this.m_rtemp2;
                        ++j;
                    }
                    ++i;
                }
                i = this.m_nlag - 1;
                while (i < this.fftlen - this.m_nlag + 2) {
                    this.tfslicer[i] = 0.0;
                    this.tfslicei[i] = 0.0;
                    ++i;
                }
                i = this.fftlen - this.m_nlag + 2;
                while (i < this.fftlen) {
                    this.tfslicer[i] = this.tfslicer[this.fftlen - i];
                    this.tfslicei[i] = -this.tfslicei[this.fftlen - i];
                    ++i;
                }
                TFR1.fft(this.fftlen, this.m_mfft, this.tfslicer, this.tfslicei);
                int itemp = this.fftlen / 2;
                j = 0;
                i = 0;
                while (i < itemp) {
                    tfr[outct][j] = this.tfslicer[i];
                    ++j;
                    i += this.m_fstep;
                }
                ++outct;
            }
            ++ii;
        }
        return tfr;
    }

    static void fft(int n, int m, double[] x, double[] y) {
        double t1;
        int n1;
        int j = 0;
        int n2 = n / 2;
        int i = 1;
        while (i < n - 1) {
            n1 = n2;
            while (j >= n1) {
                j -= n1;
                n1 /= 2;
            }
            if (i < (j += n1)) {
                t1 = x[i];
                x[i] = x[j];
                x[j] = t1;
                t1 = y[i];
                y[i] = y[j];
                y[j] = t1;
            }
            ++i;
        }
        n1 = 0;
        n2 = 1;
        i = 0;
        while (i < m) {
            n1 = n2;
            n2 += n2;
            double e = Math.PI * -2 / (double)n2;
            double a = 0.0;
            j = 0;
            while (j < n1) {
                double c = Math.cos(a);
                double s = Math.sin(a);
                a += e;
                int k = j;
                while (k < n) {
                    t1 = c * x[k + n1] - s * y[k + n1];
                    double t2 = s * x[k + n1] + c * y[k + n1];
                    x[k + n1] = x[k] - t1;
                    y[k + n1] = y[k] - t2;
                    x[k] = x[k] + t1;
                    y[k] = y[k] + t2;
                    k += n2;
                }
                ++j;
            }
            ++i;
        }
    }

    static int po2(int n) {
        int mm = 1;
        int m = 0;
        while (mm < n) {
            ++m;
            mm *= 2;
        }
        return m;
    }

    static int power(int x, int n) {
        int p = 1;
        int i = 1;
        while (i <= n) {
            p *= x;
            ++i;
        }
        return p;
    }

    static void kfill(int len, double k, double[] x) {
        int i = 0;
        while (i < len) {
            x[i] = k;
            ++i;
        }
    }

    static void cshift(int len, double[] x) {
        double rtemp = x[len - 1];
        int i = len - 1;
        while (i > 0) {
            x[i] = x[i - 1];
            --i;
        }
        x[0] = rtemp;
    }

    static double cmr(double xr, double xi, double yr, double yi) {
        double rtemp = xr * yr - xi * yi;
        return rtemp;
    }

    static double cmi(double xr, double xi, double yr, double yi) {
        double rtemp = xi * yr + xr * yi;
        return rtemp;
    }

    static double ccmr(double xr, double xi, double yr, double yi) {
        double rtemp = xr * yr + xi * yi;
        return rtemp;
    }

    static double ccmi(double xr, double xi, double yr, double yi) {
        double rtemp = xi * yr - xr * yi;
        return rtemp;
    }

    static void rectamake(int nlag, int n, double forget, double[] ar, double[] ai, double[] arN, double[] aiN) {
        double trig = 6.283185307 / (double)n;
        double decay = Math.exp(-forget);
        int j = 0;
        while (j < n) {
            ar[j] = decay * Math.cos(trig * (double)j);
            ai[j] = decay * Math.sin(trig * (double)j);
            ++j;
        }
        int i = 0;
        while (i < nlag) {
            double trigN = 6.283185307 * (double)(n - i);
            trigN /= (double)n;
            double decayN = Math.exp(-forget * (double)(n - i));
            j = 0;
            while (j < n) {
                arN[i * n + j] = decayN * Math.cos(trigN * (double)j);
                aiN[i * n + j] = decayN * Math.sin(trigN * (double)j);
                ++j;
            }
            ++i;
        }
    }

    static void pthetamake(int nrad, int nphi, int ntheta, double[] ptheta, int[] maxrad) {
        double deltheta = 6.283185307 / (double)ntheta;
        int i = 0;
        while (i < nphi) {
            maxrad[i] = nrad;
            int j = 0;
            while (j < nrad) {
                double rtemp;
                double theta = -(4.442882938 / (double)nrad * (double)j) * Math.cos(3.141592654 * (double)i / (double)nphi);
                if (theta >= 0.0) {
                    rtemp = theta / deltheta;
                    if (rtemp > (double)(ntheta / 2 - 1)) {
                        rtemp = -1.0;
                        if (j < maxrad[i]) {
                            maxrad[i] = j;
                        }
                    }
                } else {
                    rtemp = (theta + 6.283185307) / deltheta;
                    if (rtemp < (double)(ntheta / 2 + 1)) {
                        rtemp = -1.0;
                        if (j < maxrad[i]) {
                            maxrad[i] = j;
                        }
                    }
                }
                ptheta[i * nrad + j] = rtemp;
                ++j;
            }
            ++i;
        }
    }

    static void plagmake(int nrad, int nphi, int nlag, double[] plag) {
        int i = 0;
        while (i < nphi) {
            int j = 0;
            while (j < nrad) {
                plag[i * nrad + j] = TFR1.mklag(nrad, nphi, nlag, i, j);
                ++j;
            }
            ++i;
        }
    }

    static void rectopol(int nraf, int nlag, int nrad, int nphi, double[] req, double[] pheq) {
        double pi = 3.141592654;
        double deltau = Math.sqrt(pi / (double)(nlag - 1));
        double deltheta = 2.0 * Math.sqrt((double)(nlag - 1) * pi) / (double)nraf;
        double delrad = Math.sqrt(2.0 * pi * (double)(nlag - 1)) / (double)nrad;
        double delphi = pi / (double)nphi;
        int i = 0;
        while (i < nlag) {
            int j = 0;
            while (j < nraf / 2) {
                req[i * nraf + j] = Math.sqrt((double)(i * i) * deltau * deltau + (double)(j * j) * deltheta * deltheta) / delrad;
                pheq[i * nraf + j] = i == 0 ? 0.0 : (Math.atan((double)j * deltheta / ((double)i * deltau)) + 1.570796327) / delphi;
                ++j;
            }
            j = 0;
            while (j < nraf / 2) {
                int jt = j - nraf / 2;
                req[i * nraf + nraf / 2 + j] = Math.sqrt((double)(i * i) * deltau * deltau + (double)(jt * jt) * deltheta * deltheta) / delrad;
                pheq[i * nraf + nraf / 2 + j] = i == 0 ? 0.0 : (Math.atan((double)jt * deltheta / ((double)i * deltau)) + 1.570796327) / delphi;
                ++j;
            }
            ++i;
        }
    }

    static void rectrotmake(int nraf, int nlag, double outdelay, double[] rectrotr, double[] rectroti) {
        double twopin = 6.283185307 / (double)nraf;
        int i = 0;
        while (i < nlag) {
            int j = 0;
            while (j < nraf / 2) {
                rectrotr[i * nraf + j] = Math.cos(twopin * (double)j * (outdelay - (double)i / 2.0));
                rectroti[i * nraf + j] = Math.sin(twopin * (double)j * (outdelay - (double)i / 2.0));
                ++j;
            }
            j = nraf / 2;
            while (j < nraf) {
                rectrotr[i * nraf + j] = Math.cos(twopin * (double)(j - nraf) * (outdelay - (double)i / 2.0));
                rectroti[i * nraf + j] = Math.sin(twopin * (double)(j - nraf) * (outdelay - (double)i / 2.0));
                ++j;
            }
            ++i;
        }
    }

    static void rectaf(double[] xr, double[] xi, int laglen, int freqlen, double[] alphar, double[] alphai, double[] alpharN, double[] alphaiN, double[] afr, double[] afi) {
        int i = 0;
        while (i < laglen) {
            double rr = TFR1.ccmr(xr[0], xi[0], xr[i], xi[i]);
            double ri = TFR1.ccmi(xr[0], xi[0], xr[i], xi[i]);
            double rrN = TFR1.ccmr(xr[freqlen - i], xi[freqlen - i], xr[freqlen], xi[freqlen]);
            double riN = TFR1.ccmi(xr[freqlen - i], xi[freqlen - i], xr[freqlen], xi[freqlen]);
            int j = 0;
            while (j < freqlen) {
                double rtemp = TFR1.cmr(afr[i * freqlen + j], afi[i * freqlen + j], alphar[j], alphai[j]) - TFR1.cmr(rrN, riN, alpharN[i * freqlen + j], alphaiN[i * freqlen + j]) + rr;
                afi[i * freqlen + j] = TFR1.cmi(afr[i * freqlen + j], afi[i * freqlen + j], alphar[j], alphai[j]) - TFR1.cmi(rrN, riN, alpharN[i * freqlen + j], alphaiN[i * freqlen + j]) + ri;
                afr[i * freqlen + j] = rtemp;
                ++j;
            }
            ++i;
        }
    }

    static void polafint(int nrad, int nphi, int ntheta, int[] maxrad, int nlag, double[] plag, double[] ptheta, double[] rectafm2, double[] polafm2) {
        double rtemp1;
        double rtemp;
        double rtheta;
        int itheta;
        double rlag;
        int ilag;
        int j;
        int i = 0;
        while (i < nphi / 2) {
            j = 0;
            while (j < maxrad[i]) {
                ilag = (int)plag[i * nrad + j];
                rlag = plag[i * nrad + j] - (double)ilag;
                if (ilag >= nlag) {
                    polafm2[i * nrad + j] = 0.0;
                } else {
                    itheta = (int)ptheta[i * nrad + j];
                    rtheta = ptheta[i * nrad + j] - (double)itheta;
                    int itheta1 = itheta + 1;
                    if (itheta1 >= ntheta) {
                        itheta1 = 0;
                    }
                    rtemp = (rectafm2[ilag * ntheta + itheta1] - rectafm2[ilag * ntheta + itheta]) * rtheta + rectafm2[ilag * ntheta + itheta];
                    rtemp1 = (rectafm2[(ilag + 1) * ntheta + itheta1] - rectafm2[(ilag + 1) * ntheta + itheta]) * rtheta + rectafm2[(ilag + 1) * ntheta + itheta];
                    polafm2[i * nrad + j] = (rtemp1 - rtemp) * rlag + rtemp;
                }
                ++j;
            }
            ++i;
        }
        i = nphi / 2;
        while (i < nphi) {
            j = 0;
            while (j < maxrad[i]) {
                ilag = (int)plag[i * nrad + j];
                rlag = plag[i * nrad + j] - (double)ilag;
                if (ilag >= nlag) {
                    polafm2[i * nrad + j] = 0.0;
                } else {
                    itheta = (int)ptheta[i * nrad + j];
                    rtheta = ptheta[i * nrad + j] - (double)itheta;
                    rtemp = (rectafm2[ilag * ntheta + itheta + 1] - rectafm2[ilag * ntheta + itheta]) * rtheta + rectafm2[ilag * ntheta + itheta];
                    rtemp1 = (rectafm2[(ilag + 1) * ntheta + itheta + 1] - rectafm2[(ilag + 1) * ntheta + itheta]) * rtheta + rectafm2[(ilag + 1) * ntheta + itheta];
                    polafm2[i * nrad + j] = (rtemp1 - rtemp) * rlag + rtemp;
                }
                ++j;
            }
            ++i;
        }
    }

    static double mklag(int nrad, int nphi, int nlag, int iphi, int jrad) {
        double delay = 1.414213562 * (double)(nlag - 1) * (double)jrad / (double)nrad * Math.sin(3.141592654 * (double)iphi / (double)nphi);
        return delay;
    }

    static double rectkern(int itau, int itheta, int ntheta, int nphi, double[] req, double[] pheq, double[] sigma) {
        int iphi = (int)pheq[itau * ntheta + itheta];
        int iphi1 = iphi + 1;
        if (iphi1 > nphi - 1) {
            iphi1 = 0;
        }
        double tsigma = sigma[iphi] + (pheq[itau * ntheta + itheta] - (double)iphi) * (sigma[iphi1] - sigma[iphi]);
        double kern = Math.exp(-req[itau * ntheta + itheta] * req[itau * ntheta + itheta] / (tsigma * tsigma));
        return kern;
    }

    static void sigupdate(int nrad, int nphi, int nits, double vol, double mu0, int[] maxrad, double[] polafm2, double[] sigma) {
        double[] grad = new double[1024];
        int ii = 0;
        while (ii < nits) {
            double gradsum = 0.0;
            double gradsum1 = 0.0;
            int i = 0;
            while (i < nphi) {
                grad[i] = 0.0;
                double ee1 = Math.exp(-1.0 / (sigma[i] * sigma[i]));
                if (Double.isNaN(ee1)) {
                    logger.warn((Object)("Math.exp( - 1.0/(sigma[i]*sigma[i]) )=" + ee1 + ",\tsigma[i]=" + sigma[i]));
                    logger.warn((Object)"now try calc again:");
                    ee1 = Math.exp(-1.0 / (sigma[i] * sigma[i]));
                    logger.warn((Object)("Math.exp( - 1.0/(sigma[i]*sigma[i]) )=" + ee1 + ",\tsigma[i]=" + sigma[i]));
                }
                double ee2 = 1.0;
                double eec = ee1 * ee1;
                int j = 1;
                while (j < maxrad[i]) {
                    ee2 = ee1 * ee2;
                    ee1 = eec * ee1;
                    grad[i] = grad[i] + (double)(j * j * j) * ee2 * polafm2[i * nrad + j];
                    ++j;
                }
                grad[i] = grad[i] / (sigma[i] * sigma[i] * sigma[i]);
                gradsum += grad[i] * grad[i];
                gradsum1 += sigma[i] * grad[i];
                ++i;
            }
            gradsum1 *= 2.0;
            if (gradsum < 1.0E-7) {
                gradsum = 1.0E-7;
            }
            if (gradsum1 < 1.0E-7) {
                gradsum1 = 1.0E-7;
            }
            double mu = (Math.sqrt(gradsum1 * gradsum1 + 4.0 * gradsum * vol * mu0) - gradsum1) / (2.0 * gradsum);
            double tvol = 0.0;
            i = 0;
            while (i < nphi) {
                sigma[i] = sigma[i] + mu * grad[i];
                if (sigma[i] < 0.5) {
                    sigma[i] = 0.5;
                }
                tvol += sigma[i] * sigma[i];
                ++i;
            }
            double volfac = Math.sqrt(vol / tvol);
            i = 0;
            while (i < nphi) {
                sigma[i] = volfac * sigma[i];
                ++i;
            }
            ++ii;
        }
    }

    static void mkmag2(int tlen, double[] xr, double[] xi, double[] xm2) {
        int i = 0;
        while (i < tlen) {
            xm2[i] = xr[i] * xr[i] + xi[i] * xi[i];
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println();
        System.out.println("ADAPTIVE OPTIMAL-KERNEL (AOK) TIME-FREQUENCY REPRESENTATION\n");
        System.out.println();
        System.out.println("  Version 4.0\n");
        System.out.println("  java TFR1.aok in_file, out_file xlen tlag fftlen tstep vol");
        System.out.println();
        System.out.println("\tin_file:\tInput File");
        System.out.println("\tout_file:\tOutput File");
        System.out.println("\txlen:\tNumber of signal samples in input file");
        System.out.println("\ttlag:\tLength of sliding analysis window?  (power of two, no larger than 256)");
        System.out.println(" \t(Number of samples along each dimension of the STAF)");
        System.out.println("\tfftlen:\tNumber of output frequency samples per time-slice  (power of two)");
        System.out.println("\ttstep:\tTime increment in samples between time-slice outputs");
        System.out.println("\tvol:\tNormalized volume of optimal kernel");
        System.out.println("\t(Typically between 1 and 5)");
        BufferedReader frdr = new BufferedReader(new FileReader(args[0]));
        BufferedWriter fwrtr = new BufferedWriter(new FileWriter(args[1]));
        int xlen = Integer.parseInt(args[2]);
        int tlag = Integer.parseInt(args[3]);
        int fftlen = Integer.parseInt(args[4]);
        int tstep = Integer.parseInt(args[5]);
        double vol = Double.parseDouble(args[6]);
        double[][] signal = new double[2][xlen];
        int ntime = (int)Math.ceil((double)(xlen + tlag + 2) / (double)tstep);
        double[][] tfr = new double[ntime][fftlen];
        System.out.println("xlen= " + xlen);
        System.out.println("tlag= " + tlag);
        System.out.println("fftlen= " + fftlen);
        System.out.println("tstep= " + tstep);
        System.out.println("vol= " + vol);
        System.out.println("tfr.t= " + ntime);
        String line = null;
        StringTokenizer st = null;
        int i = 0;
        while (i < xlen) {
            line = frdr.readLine();
            st = new StringTokenizer(line);
            signal[0][i] = Double.parseDouble(st.nextToken());
            signal[1][i] = Double.parseDouble(st.nextToken());
            ++i;
        }
        frdr.close();
        TFR1 aok = new TFR1();
        aok.init(tlag, fftlen, tstep, vol);
        tfr = new double[xlen - 2 * tlag][fftlen];
        aok.aok(signal, tlag, xlen - 2 * tlag, tfr);
        int t = 0;
        while (t < tfr.length) {
            int f = 0;
            while (f < fftlen) {
                fwrtr.write(tfr[t][f] + " ");
                ++f;
            }
            fwrtr.newLine();
            ++t;
        }
        fwrtr.close();
    }
}

