/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import JSci.maths.Mapping;
import JSci.util.ArrayCaster;

public class NumericProcess {
    private NumericProcess() {
    }

    public static int[] trapezium(int[] funVal, double h) {
        return ArrayCaster.toInt((double[])NumericProcess.trapezium(ArrayCaster.toDouble((int[])funVal), h));
    }

    public static double[] trapezium(double[] func, double h) {
        int N = func.length - 1;
        if (N < 0) {
            throw new Error("in NumericProcess.trapzium(),N must be >1");
        }
        double[] arrayA = new double[func.length];
        double A = 0.0;
        int i = 0;
        while (i < N) {
            arrayA[i + 1] = A += func[i] + func[i + 1];
            ++i;
        }
        double h2 = h / 2.0;
        int i2 = 0;
        while (i2 < arrayA.length) {
            int n = i2++;
            arrayA[n] = arrayA[n] * h2;
        }
        return arrayA;
    }

    public static double simpson(int N, Mapping func, double a, double b) {
        double Ao = 0.0;
        double Ae = 0.0;
        double x = a;
        double h = (b - a) / (double)(2 * N);
        int i = 0;
        while (i < N - 1) {
            Ao += func.map(x + h);
            Ae += func.map(x + 2.0 * h);
            x += 2.0 * h;
            ++i;
        }
        return h / 3.0 * (func.map(a) + 4.0 * (Ao += func.map(x + h)) + 2.0 * Ae + func.map(b));
    }

    public static double richardson(int N, Mapping func, double a, double b) {
        double Aao = 0.0;
        double Aae = 0.0;
        double Abo = 0.0;
        double Abe = 0.0;
        double x = a;
        double ha = (b - a) / (double)(2 * N);
        double hb = ha / 2.0;
        int i = 0;
        while (i < N - 1) {
            Aao += func.map(x + ha);
            Aae += func.map(x + 2.0 * ha);
            Abo += func.map(x + hb);
            Abe += func.map(x + 2.0 * hb);
            Abo += func.map(x + 3.0 * hb);
            Abe += func.map(x + 4.0 * hb);
            x += 2.0 * ha;
            ++i;
        }
        Abo += func.map(x + hb);
        double Aa = ha / 3.0 * (func.map(a) + 4.0 * (Aao += func.map(x + ha)) + 2.0 * Aae + func.map(b));
        double Ab = hb / 3.0 * (func.map(a) + 4.0 * (Abo += func.map(x + 3.0 * hb)) + 2.0 * (Abe += func.map(x + 2.0 * hb)) + func.map(b));
        return (16.0 * Ab - Aa) / 15.0;
    }

    public static double gaussian4(int N, Mapping func, double a, double b) {
        double A = 0.0;
        double h = (b - a) / (double)N;
        double h2 = h / 2.0;
        double[] zeros = new double[4];
        double[] coeffs = new double[4];
        zeros[2] = 0.33998104358485626;
        zeros[3] = 0.8611363115940526;
        zeros[0] = -zeros[3];
        zeros[1] = -zeros[2];
        coeffs[3] = 0.34785484513745385;
        coeffs[0] = 0.34785484513745385;
        coeffs[2] = 0.6521451548625461;
        coeffs[1] = 0.6521451548625461;
        int n = 0;
        while (n < N) {
            int i = 0;
            while (i < zeros.length) {
                A += coeffs[i] * func.map(a + (zeros[i] + 1.0) * h2);
                ++i;
            }
            a += h;
            ++n;
        }
        return A * h2;
    }

    public static double gaussian8(int N, Mapping func, double a, double b) {
        double A = 0.0;
        double h = (b - a) / (double)N;
        double h2 = h / 2.0;
        double[] zeros = new double[8];
        double[] coeffs = new double[8];
        zeros[4] = 0.1834346424956498;
        zeros[5] = 0.525532409916329;
        zeros[6] = 0.7966664774136267;
        zeros[7] = 0.9602898564975363;
        zeros[0] = -zeros[7];
        zeros[1] = -zeros[6];
        zeros[2] = -zeros[5];
        zeros[3] = -zeros[4];
        coeffs[7] = 0.10122853629037626;
        coeffs[0] = 0.10122853629037626;
        coeffs[6] = 0.22238103445337448;
        coeffs[1] = 0.22238103445337448;
        coeffs[5] = 0.31370664587788727;
        coeffs[2] = 0.31370664587788727;
        coeffs[4] = 0.362683783378362;
        coeffs[3] = 0.362683783378362;
        int n = 0;
        while (n < N) {
            int i = 0;
            while (i < zeros.length) {
                A += coeffs[i] * func.map(a + (zeros[i] + 1.0) * h2);
                ++i;
            }
            a += h;
            ++n;
        }
        return A * h2;
    }

    public static int[] differentiate(int[] func, double dx) {
        return ArrayCaster.toInt((double[])NumericProcess.differentiate(ArrayCaster.toDouble((int[])func), dx));
    }

    public static double[] differentiate(double[] func, double dx) {
        int N = func.length - 1;
        double[] diff = new double[func.length];
        double dx2 = dx * 2.0;
        diff[0] = (func[1] - func[0]) / dx;
        diff[N] = (func[N] - func[N - 1]) / dx;
        int i = 1;
        while (i < N) {
            diff[i] = (func[i + 1] - func[i - 1]) / dx2;
            ++i;
        }
        return diff;
    }

    public static double[] fwt(double[] p, int n, int k) {
        int j;
        double[] x = new double[n];
        int m = 1;
        int l = n;
        int it = 2;
        x[0] = 1.0;
        int ii = n / 2;
        x[ii] = 2.0;
        int i = 1;
        while (i <= k - 1) {
            m += m;
            l /= 2;
            it += it;
            j = 0;
            while (j <= m - 1) {
                x[j * l + l / 2] = (double)(it + 1) - x[j * l];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i <= n - 1) {
            ii = (int)x[i] - 1;
            x[i] = p[ii];
            ++i;
        }
        l = 1;
        i = 1;
        while (i <= k) {
            m = n / (2 * l) - 1;
            j = 0;
            while (j <= m) {
                it = 2 * l * j;
                int is = 0;
                while (is <= l - 1) {
                    double q = x[it + is] + x[it + is + l];
                    x[it + is + l] = x[it + is] - x[it + is + l];
                    x[it + is] = q;
                    ++is;
                }
                ++j;
            }
            l *= 2;
            ++i;
        }
        return x;
    }
}

