/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

import cn.org.gddsn.signal.Hilbert;
import com.nr.Complex;
import org.apache.log4j.Logger;

public class Numeric {
    static Logger logger = Logger.getLogger(Numeric.class);

    private Numeric() {
    }

    public static void semblanceFloat(int nrec, int ndata, int nw, float[][] f, float[] s) {
        int i;
        double norm = 1.0 / (double)nrec;
        if (nw < 0) {
            nw = 0;
        }
        double[] q = new double[nw + 1];
        float[] gg = new float[ndata];
        float[] gx = new float[ndata];
        int k = 0;
        while (k < nrec) {
            float[] fk = f[k];
            i = 0;
            while (i < ndata) {
                float fki = fk[i];
                int n = i;
                gg[n] = gg[n] + fki;
                int n2 = i++;
                gx[n2] = gx[n2] + fki * fki;
            }
            ++k;
        }
        i = 0;
        while (i < ndata) {
            int n = i;
            gg[n] = gg[n] * gg[i];
            ++i;
        }
        int kk = 0;
        while (kk <= nw) {
            q[kk] = (double)(nw + 1 - kk) / (double)(nw + 1);
            ++kk;
        }
        i = 0;
        while (i < ndata) {
            double sx = 0.0;
            double ss = 0.0;
            k = -nw;
            while (k <= nw) {
                int n = kk = k > 0 ? k : -k;
                if (i + k >= 0 && i + k < ndata) {
                    ss += q[kk] * (double)gg[i + k];
                    sx += q[kk] * (double)gx[i + k];
                }
                ++k;
            }
            s[i] = sx / ss < ss * 1.0E-20 ? 0.0f : (float)(norm * ss / sx);
            ++i;
        }
    }

    public static void semblanceDouble(int nrec, int ndata, int nw, double[][] f, double[] s) {
        int i;
        double norm = 1.0 / (double)nrec;
        if (nw < 0) {
            nw = 0;
        }
        double[] q = new double[nw + 1];
        double[] gg = new double[ndata];
        double[] gx = new double[ndata];
        int k = 0;
        while (k < nrec) {
            double[] fk = f[k];
            i = 0;
            while (i < ndata) {
                double fki = fk[i];
                int n = i;
                gg[n] = gg[n] + fki;
                int n2 = i++;
                gx[n2] = gx[n2] + fki * fki;
            }
            ++k;
        }
        i = 0;
        while (i < ndata) {
            int n = i;
            gg[n] = gg[n] * gg[i];
            ++i;
        }
        int kk = 0;
        while (kk <= nw) {
            q[kk] = (double)(nw + 1 - kk) / (double)(nw + 1);
            ++kk;
        }
        i = 0;
        while (i < ndata) {
            double sx = 0.0;
            double ss = 0.0;
            k = -nw;
            while (k <= nw) {
                int n = kk = k > 0 ? k : -k;
                if (i + k >= 0 && i + k < ndata) {
                    ss += q[kk] * gg[i + k];
                    sx += q[kk] * gx[i + k];
                }
                ++k;
            }
            s[i] = sx / ss < ss * 1.0E-20 ? 0.0 : norm * ss / sx;
            ++i;
        }
    }

    public static void semblanceComplexDouble(int nrec, int ndata, int nw, double[][] f, double[] s) {
        int i;
        double norm = 1.0 / (double)nrec;
        double[] q = new double[nw + 1];
        double[] gg = new double[ndata];
        double[] gh = new double[ndata];
        double[] gx = new double[ndata];
        double[] fh = new double[ndata];
        if (nw < 0) {
            nw = 0;
        }
        int k = 0;
        while (k < nrec) {
            double[] fk = f[k];
            i = 0;
            while (i < ndata) {
                fh[i] = fk[i];
                ++i;
            }
            fh = Hilbert.hilbert(fh);
            i = 0;
            while (i < ndata) {
                double fki = fk[i];
                double fhi = fh[i];
                int n = i;
                gg[n] = gg[n] + fki;
                int n2 = i;
                gh[n2] = gh[n2] + fhi;
                int n3 = i++;
                gx[n3] = gx[n3] + (fki * fki + fhi * fhi);
            }
            ++k;
        }
        i = 0;
        while (i < ndata) {
            int n = i;
            gg[n] = gg[n] * gg[i];
            int n4 = i;
            gh[n4] = gh[n4] * gh[i];
            ++i;
        }
        int kk = 0;
        while (kk <= nw) {
            q[kk] = (double)(nw + 1 - kk) / (double)(nw + 1);
            ++kk;
        }
        i = 0;
        while (i < ndata) {
            double sx = 0.0;
            double ss = 0.0;
            k = -nw;
            while (k <= nw) {
                int n = kk = k > 0 ? k : -k;
                if (i + k >= 0 && i + k < ndata) {
                    ss += q[kk] * (gg[i + k] + gh[i + k]);
                    sx += q[kk] * gx[i + k];
                }
                ++k;
            }
            s[i] = sx / ss < ss * 1.0E-20 ? 0.0 : norm * ss / sx;
            ++i;
        }
    }

    public static void spline2_double(int n, double[] y, double[] y2, double yp1, double ypn) {
        double qn;
        double un;
        double[] u = new double[n];
        if (yp1 > 9.9E29) {
            u[0] = 0.0;
            y2[0] = 0.0;
        } else {
            y2[0] = -0.5;
            u[0] = 3.0 * (y[1] - y[0] - yp1);
        }
        int i = 1;
        while (i < n - 1) {
            double p = 0.5 * y2[i - 1] + 2.0;
            y2[i] = -0.5 / p;
            u[i] = y[i + 1] - y[i] - y[i] + y[i - 1];
            u[i] = (3.0 * u[i] - 0.5 * u[i - 1]) / p;
            ++i;
        }
        if (ypn > 9.9E29) {
            un = 0.0;
            qn = 0.0;
        } else {
            qn = 0.5;
            un = 3.0 * (ypn - y[n - 1] + y[n - 2]);
        }
        y2[n - 1] = (un - qn * u[n - 2]) / (qn * y2[n - 2] + 1.0);
        int k = n - 1;
        while (k > 0) {
            y2[k - 1] = y2[k - 1] * y2[k] + u[k - 1];
            --k;
        }
    }

    static double splint2_double(int n, double[] ya, double[] y2a, double x) {
        if (x < 0.0 || x > (double)n) {
            return 0.0;
        }
        int klo = (int)Math.floor(x);
        int khi = klo + 1;
        double a = (double)khi - x;
        double b = x - (double)klo;
        double value = a * ya[klo] + b * ya[khi] + ((a * a * a - a) * y2a[klo] + (b * b * b - b) * y2a[khi]) * 0.16666666666666666;
        return value;
    }

    public static int resamp_double(int n1, double[] f1, int n2, double[] f2, double q) {
        if (Math.abs(q - 1.0) < 0.001) {
            return 1;
        }
        double[] fa = new double[n1];
        Numeric.spline2_double(n1, f1, fa, 1.0E30, 1.0E30);
        int i = 0;
        while (i < n2) {
            f2[i] = Numeric.splint2_double(n1, f1, fa, (double)i * q);
            ++i;
        }
        return 1;
    }

    int rotate(int n, double[] f1, double[] f2, double phi) {
        double m11 = Math.cos(phi * Math.PI / 180.0);
        double m12 = Math.sin(phi * Math.PI / 180.0);
        double m21 = -m12;
        double m22 = m11;
        int i = 0;
        while (i < n) {
            double x = f1[i] * m11 + f2[i] * m12;
            double y = f1[i] * m21 + f2[i] * m22;
            f1[i] = x;
            f2[i] = y;
            ++i;
        }
        return 0;
    }

    int decomp(int n, double[] f1, double[] f2, double p, double vs, double sigma) {
        double VPVS = Math.sqrt((2.0 - 2.0 * sigma) / (1.0 - 2.0 * sigma));
        double vp = vs * VPVS;
        if (p >= 1.0 / vp) {
            return -1;
        }
        double qa = Math.sqrt(1.0 / (vp * vp) - p * p);
        double qb = Math.sqrt(1.0 / (vs * vs) - p * p);
        double m11 = -(2.0 * vs * vs * p * p - 1.0) / (vp * qa);
        double m12 = 2.0 * p * vs * vs / vp;
        double m21 = -2.0 * p * vs;
        double m22 = (1.0 - 2.0 * vs * vs * p * p) / (vs * qb);
        int i = 0;
        while (i < n) {
            double x = f1[i] * m11 + f2[i] * m12;
            double y = f1[i] * m21 + f2[i] * m22;
            f1[i] = x;
            f2[i] = y;
            ++i;
        }
        return 0;
    }

    public static int mktaper(int nsamp, double[] f, double frac1, double frac2) {
        if (frac1 == frac2) {
            int n = (int)((double)nsamp * frac1);
            int i = 0;
            double inx = Math.PI / (double)n;
            while (i < n) {
                double ff;
                f[i] = ff = 0.5 - 0.5 * Math.cos((double)i * inx);
                f[nsamp - i - 1] = ff;
                ++i;
            }
        } else {
            int n1 = (int)((double)nsamp * frac1);
            int n2 = (int)((double)nsamp * frac2);
            int i = 0;
            double inx = Math.PI / (double)n1;
            while (i < n1) {
                f[i] = 0.5 - 0.5 * Math.cos((double)i * inx);
                ++i;
            }
            i = 0;
            inx = Math.PI / (double)n2;
            while (i < n2) {
                f[nsamp - i - 1] = 0.5 - 0.5 * Math.cos((double)i * inx);
                ++i;
            }
        }
        return 0;
    }

    public static double[] taper(double[] fr, int n, double perc) {
        return Numeric.taper(fr, n, (int)((double)n * perc));
    }

    public static double[] taper(double[] fr, int n, int nz) {
        double x = 1.5707963267948966 / (double)nz;
        int m = 0;
        while (m < nz) {
            fr[m] = fr[m] * Math.sin((double)m * x);
            ++m;
        }
        m = n - nz;
        while (m < n) {
            fr[m] = fr[m] * Math.sin((double)(n - m) * x);
            ++m;
        }
        return fr;
    }

    public static double[] costap(double[] fr, int n, double perc) {
        int nz = (int)((double)n * perc);
        double x = Math.PI / (double)nz;
        int m = 0;
        while (m < nz) {
            fr[m] = fr[m] * (1.0 - Math.cos((double)m * x)) / 2.0;
            ++m;
        }
        m = n - nz;
        while (m < n) {
            fr[m] = fr[m] * (1.0 - Math.cos((double)(n - m) * x)) / 2.0;
            ++m;
        }
        return fr;
    }

    public static int nextPowerOf2(int len) {
        if (len <= 0) {
            return 0;
        }
        int n = 1;
        while (n < len) {
            n <<= 1;
        }
        return n;
    }

    public static double[] envelopeRC(double[] x, double srate, double cutoffFreq) {
        double M = srate * (Math.PI * 2 * cutoffFreq);
        double[] y = new double[x.length];
        y[0] = x[0];
        int k = 1;
        while (k < y.length) {
            y[k] = y[k - 1] + Math.abs(x[k] - y[k - 1]) / M;
            ++k;
        }
        return y;
    }

    public static void main(String[] args) {
        Numeric.testResamp_double();
    }

    public static void testResamp_double() {
        int ndata = 2048;
        double[] f = new double[ndata];
        double F = 3.0;
        double sr = 100.0;
        int j = 0;
        while (j < ndata) {
            double t = (double)j / sr;
            f[j] = Math.sin(Math.PI * 2 * F * t);
            ++j;
        }
        double q = 2.0;
        double[] f2 = new double[(int)((double)ndata / q)];
        Numeric.resamp_double(ndata, f, (int)((double)ndata / q), f2, q);
        int i = 0;
        while (i < (int)((double)ndata / q)) {
            System.out.println(String.valueOf(f[i * (int)q]) + "\t" + f2[i]);
            ++i;
        }
    }

    public static void testSemblance(String[] args) {
        int nrec = 2;
        int ndata = 2048;
        double[][] f = new double[nrec][ndata];
        double F = 3.0;
        double sr = 100.0;
        int i = 0;
        while (i < f.length) {
            int j = 0;
            while (j < ndata) {
                double t = (double)j / sr;
                f[i][j] = Math.sin(Math.PI * 2 * F * t);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < ndata) {
            double t = (double)j / sr;
            f[1][j] = 1.0 * Math.cos(Math.PI * 2 * (F + 0.0) * t);
            ++j;
        }
        double[] s = new double[ndata];
        Numeric.semblanceComplexDouble(nrec, ndata, 5, f, s);
        int i2 = 0;
        while (i2 < 2048) {
            System.out.println(String.valueOf(f[0][i2]) + "\t" + f[1][i2] + "\t" + s[i2]);
            ++i2;
        }
    }

    public static void linearFillGaps(double[] samp) {
        int sz = -1;
        int ez = -1;
        int i = 0;
        while (i < samp.length) {
            if (Math.abs(samp[i]) < 1.0) {
                if (sz == -1) {
                    sz = i;
                } else {
                    ez = i;
                }
            } else {
                if (ez - sz > 3 && sz - 1 > 0 && ez + 1 < samp.length) {
                    double a = samp[sz - 1];
                    double b = samp[ez + 1];
                    int j = sz;
                    while (j <= ez) {
                        samp[j] = a + (b - a) * (double)(j - sz + 1) / (double)(ez - sz + 2);
                        ++j;
                    }
                }
                sz = -1;
                ez = -1;
            }
            ++i;
        }
    }

    Complex calcSNR(double[] data, int N, int len) {
        int N1;
        int N0 = N;
        if (N0 > data.length) {
            N0 = data.length;
        }
        if ((N1 = data.length - N0) > N) {
            N1 = N0;
        }
        int N2 = N0 > N1 ? N0 - N1 : 0;
        logger.info((Object)String.format("calcSNR(): size= %d  N= %d  N0= %d  N1= %d  N2= %d", data.length, N, N0, N1, N2));
        double offset = 0.0;
        int n = N2;
        while (n < N) {
            offset += data[n];
            ++n;
        }
        offset /= (double)(N - N2);
        double rmsNoise2 = 0.0;
        int n2 = N2;
        while (n2 < N) {
            rmsNoise2 += Math.pow(data[n2] - offset, 2.0);
            ++n2;
        }
        rmsNoise2 /= (double)(N - N2);
        offset = 0.0;
        n2 = N;
        while (n2 < N + N1) {
            offset += data[n2];
            ++n2;
        }
        offset /= (double)N1;
        double rmsSignal2 = 0.0;
        int n3 = N;
        while (n3 < N + N1) {
            rmsSignal2 += Math.pow(data[n3] - offset, 2.0);
            ++n3;
        }
        logger.info((Object)String.format("calcSNR(): signal2= %f", rmsSignal2 /= (double)N1));
        logger.info((Object)String.format("calcSNR(): noise2=  %f", rmsNoise2));
        logger.info((Object)String.format("calcSNR(): SNR_1=   %f", rmsSignal2 / rmsNoise2));
        offset = 0.0;
        n3 = 0;
        while (n3 < N) {
            offset += data[n3];
            ++n3;
        }
        offset /= (double)N;
        double rmsNoise = 0.0;
        int n4 = 0;
        while (n4 < N) {
            rmsNoise += Math.pow(data[n4] - offset, 2.0);
            ++n4;
        }
        rmsNoise = Math.sqrt(rmsNoise / (double)N);
        offset = 0.0;
        n4 = N;
        while (n4 < N + len) {
            offset += data[n4];
            ++n4;
        }
        offset /= (double)(data.length - N);
        double absMax = 0.0;
        int n5 = N;
        while (n5 < N + len) {
            double d;
            double a = Math.abs(data[n5] - offset);
            if (d > absMax) {
                absMax = a;
            }
            ++n5;
        }
        logger.info((Object)String.format("calcSNR(): absMax=  %f", absMax));
        logger.info((Object)String.format("calcSNR(): noise=   %f", rmsNoise));
        logger.info((Object)String.format("calcSNR(): noisex=  %f", Math.sqrt(rmsNoise2)));
        logger.info((Object)String.format("calcSNR(): SNR_2=   %f", absMax / rmsNoise));
        offset = 0.0;
        n5 = 0;
        while (n5 < N) {
            offset += data[n5];
            ++n5;
        }
        offset /= (double)N;
        double meanNoise = 0.0;
        int n6 = 0;
        while (n6 < N) {
            meanNoise += Math.abs(data[n6] - offset);
            ++n6;
        }
        meanNoise /= (double)N;
        offset = 0.0;
        n6 = N;
        while (n6 < data.length) {
            offset += data[n6];
            ++n6;
        }
        offset /= (double)(data.length - N);
        double meanSignal = 0.0;
        int n7 = N;
        while (n7 < data.length) {
            meanSignal += Math.abs(data[n7] - offset);
            ++n7;
        }
        logger.debug((Object)String.format("calcSNR(): absMax=  %f", absMax));
        logger.debug((Object)String.format("calcSNR(): meanNoi= %f", meanNoise));
        logger.debug((Object)String.format("calcSNR(): SNR_3=   %f", absMax / meanNoise));
        logger.debug((Object)String.format("calcSNR(): meanSig= %f", meanSignal /= (double)(data.length - N)));
        logger.debug((Object)String.format("calcSNR(): SNR_4=   %f", meanSignal / meanNoise));
        return new Complex(absMax / rmsNoise, offset);
    }
}

