/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal;

public class FirInterpolator {
    private double[] p_H;
    private int factor_L;
    int num_taps_per_phase;
    private double[] p_Z;

    public FirInterpolator(double[] fir, int factor_L) {
        this.p_H = fir;
        this.factor_L = factor_L;
        if (fir.length % factor_L != 0) {
            throw new IllegalArgumentException("The number of taps in the filter must be divisible by factor_L.");
        }
        this.num_taps_per_phase = fir.length / factor_L;
        this.p_Z = new double[this.num_taps_per_phase];
    }

    public double[] getDelayLineArray() {
        return this.p_Z;
    }

    public int interp(double[] p_inp, int offInp, int num_inp, double[] p_out, int offOut) {
        int idxIn = offInp;
        int idxOut = offOut;
        int idxCoeff = 0;
        int num_out = 0;
        while (--num_inp > 0) {
            int tap = this.num_taps_per_phase - 1;
            while (tap > 0) {
                this.p_Z[tap] = this.p_Z[tap - 1];
                --tap;
            }
            this.p_Z[0] = p_inp[idxIn++];
            int phase_num = 0;
            while (phase_num < this.factor_L) {
                idxCoeff = phase_num;
                double sum = 0.0;
                tap = 0;
                while (tap < this.num_taps_per_phase) {
                    sum += this.p_H[idxCoeff] * this.p_Z[tap];
                    idxCoeff += this.factor_L;
                    ++tap;
                }
                p_out[idxOut++] = sum;
                ++num_out;
                ++phase_num;
            }
        }
        return num_out;
    }
}

